#ifndef _FIREFLIERIO_H_
#define _FIREFLIERIO_H_

#include <openssl/ssl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
//#include <map>
#include <glibmm/ustring.h>
#include "CRefPtr.h"

using Glib::ustring;


class CffIO
{
	static SSL* m_ssl;
	static SSL_CTX* m_ctx;
	static SSL_METHOD* m_meth;
	static in_addr_t m_nHostIP;
	static guint16 m_nPort;

public:
	enum CommErr
	{
		// ssl-errors are 0 and below, so use value above 0
		COMMERR_CONN_NOTVALID = 1, 
		COMMERR_NO_MEMORY, 
	};
	
	class CffIOError
	{
	private:
		int m_nError;
		//static std::map <int, ustring> m_mapErr2Str;
	
	public:
		CffIOError(int nError)
			: m_nError(nError)
		{
		}
		
		int getErrorNum() const
		{
			return m_nError;
		}
		
		
	};

	
	typedef CRefPtr <CffIO::CffIOError> pCffIOError;

	class CNetworkThread;

public:
	static CNetworkThread networkThread;
	
public:
	static void setSocket(const char* szIP, guint16 nPort)
	{
		in_addr addr;
		inet_aton(szIP, &addr);
		m_nHostIP = addr.s_addr;
		m_nPort = nPort;
	}
	
	static bool connect();
	
	static void end();

	operator SSL&()
	{
		return *m_ssl;
	}
};
	

#include "CNetworkThread.h"
#include "CCO_All.h"
extern CffIO ffIO;

SSL& operator <<(SSL& ssl, const CCO_SendBase& co);
SSL& operator >>(SSL& ssl, CCO_RetrieveBase& co);

#endif
