Summary: A perl http proxy with the capability to modify proxied content.
Name: FilterProxy
Version: 0.30
Release: 1
Packager: John Conneely <jconneely@figaro.org>
Copyright: GPL + usage requrements (see licenses for details)
URL: http://draal.physics.wisc.edu/FilterProxy/
Group: System Environment/Daemons
Source: FilterProxy-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
%define build_dir $RPM_BUILD_DIR/FilterProxy-%{version}
%define proxy_user filterproxy
%define proxy_home /home/%{proxy_user}
BuildArch: noarch
Requires: perl perl-HTML-Mason perl-Compress-Zlib perl-HTML-Parser perl-Time-HiRes perl-libwww-perl perl-URI

%description
FilterProxy is a generic http proxy with the capability to modify proxied
content on the fly. It has a modular system of filters which can modify web
pages any way you desire. The modular system means that many filters can be
applied in succession to a web page, and configuration is easy and flexible.
FilterProxy can proxy any data served by the HTTP protocol (i.e. anything
off the web), and filter any recognizable mime-type. All configuration is done
via web-based forms, or editing a configuration file.

%prep
%setup

%build

%install
#Delete the temp install area, as long it isn't /.  (That would be very bad. :) )
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

#Create home directory if it isn't there.
#[ -d "$RPM_BUILD_ROOT" ] || mkdir $RPM_BUILD_ROOT
#[ -d "$RPM_BUILD_ROOT/home" ] || mkdir $RPM_BUILD_ROOT/home
#[ -d "$RPM_BUILD_ROOT/home/%{proxy_user}" ] || mkdir $RPM_BUILD_ROOT/home/%{proxy_user}
#[ -d "$RPM_BUILD_ROOT/etc" ] || mkdir $RPM_BUILD_ROOT/etc
#[ -d "$RPM_BUILD_ROOT/etc/rc.d" ] || mkdir $RPM_BUILD_ROOT/etc/rc.d
#[ -d "$RPM_BUILD_ROOT/etc/rc.d/init.d" ] || mkdir $RPM_BUILD_ROOT/etc/rc.d/init.d
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{proxy_home} $RPM_BUILD_ROOT/etc/rc.d/init.d
#Install main stuff
cp -r %{build_dir}/FilterProxy* %{build_dir}/html %{build_dir}/xsl %{build_dir}/Mason $RPM_BUILD_ROOT%{proxy_home}
cp -r %{build_dir}/FilterProxy.init $RPM_BUILD_ROOT/etc/rc.d/init.d/filterproxy

#cp -r %{build_dir}/FilterProxy* $RPM_BUILD_ROOT/home/%{proxy_user}
#cp -r %{build_dir}/html $RPM_BUILD_ROOT/home/%{proxy_user}
#cp -r %{build_dir}/FilterProxy.init $RPM_BUILD_ROOT/etc/rc.d/init.d/filterproxy

#Create docs directory if it isn't there...
mkdir -p $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
cp BUGS COPYING ChangeLog INSTALL README TODO $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
#[ -d "$RPM_BUILD_ROOT/usr" ] || mkdir $RPM_BUILD_ROOT/usr
#[ -d "$RPM_BUILD_ROOT/usr/doc" ] || mkdir $RPM_BUILD_ROOT/usr/doc
#[ -d "$RPM_BUILD_ROOT/usr/doc/FilterProxy-%{version}" ] || mkdir $RPM_BUILD_ROOT/usr/doc/FilterProxy-%{version}
#cp BUGS $RPM_BUILD_ROOT/usr/doc/FilterProxy-%{version}
#cp COPYING $RPM_BUILD_ROOT/usr/doc/FilterProxy-%{version}
#cp ChangeLog $RPM_BUILD_ROOT/usr/doc/FilterProxy-%{version}
#cp INSTALL $RPM_BUILD_ROOT/usr/doc/FilterProxy-%{version}
#cp README $RPM_BUILD_ROOT/usr/doc/FilterProxy-%{version}
#cp TODO $RPM_BUILD_ROOT/usr/doc/FilterProxy-%{version}

%clean


%pre

if [ "$1" = 1 ]; then
	#If we get here, this is a new install, not an upgrade.
	useradd %{proxy_user} -s /bin/false -d ${proxy_home}
	cd %{proxy_home}
	rm -rf .[a-z]*
fi
	
%post


%preun

%postun

if [ "$1" = 0 ]; then
	#If we get here, this is an uninstall, not just an upgrade.
	userdel %{proxy_user}
fi


%files
%defattr(-, filterproxy, filterproxy)
%dir %{proxy_home}/
%{proxy_home}/*
#%dir /home/%{proxy_user}/
#/home/%{proxy_user}/*
/etc/rc.d/init.d/filterproxy
%doc BUGS COPYING ChangeLog INSTALL README TODO


%changelog

* Tue Mar 13 2001 Bob McElrath <mcelrath+filterproxy@draal.physics.wisc.edu>
- Removed LICENSE

* Mon Dec  4 2000 David MacKenzie <djm@web.us.uu.net> 0.25-2
- Make the home directory configurable in the spec file.
- Simplify the installation commands.
- Use _docdir.

* Fri Jun 14 2000 Bob McElrath <mcelrath+filterproxy@draal.physics.wisc.edu>
- Added perl-HTML-Parser back in (*sigh* too many damn dependencies),
  it's required by LWP.

* Sun May 21 2000 Bob McElrath <mcelrath+filterproxy@draal.physics.wisc.edu>
- Bug fixes, spelling mistake
- added /etc/rc.d/init.d/filterproxy
- removed perl-HTML-Parser from requires list.

* Sun May 21 2000 John Conneely <jconneely@figaro.org>
- Added perl-HTML-Parser & perl-URI to requires list
- Modified default permissions to use new filterproxy user.
- Updated install and uninstall scripts so that filterproxy user
  is always available at install / uninstall time.

* Wed May 17 2000 John Conneely <jconneely@figaro.org>
- initial spec.

