/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  File-Roller
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef FR_COMMAND_TAR_H
#define FR_COMMAND_TAR_H


#include <gtk/gtk.h>
#include "fr-command.h"
#include "fr-process.h"
#include "typedefs.h"


#define FR_COMMAND_TAR_TYPE        fr_command_tar_get_type ()
#define FR_COMMAND_TAR(o)          GTK_CHECK_CAST (o, FR_COMMAND_TAR_TYPE, FRCommandTar)
#define FR_COMMAND_TAR_CLASS(k)    GTK_CHECK_CLASS_CAST (k, FR_COMMAND_TAR_TYPE, FRCommandTarClass)
#define IS_FR_COMMAND_TAR(o)       GTK_CHECK_TYPE (o, FR_COMMAND_TAR_TYPE)


typedef struct _FRCommandTar       FRCommandTar;
typedef struct _FRCommandTarClass  FRCommandTarClass;


struct _FRCommandTar
{
	FRCommand  __parent;

	/*<private>*/

	FRCompressProgram compress_prog;
	gchar *uncomp_filename;
	gboolean name_modified;
};


struct _FRCommandTarClass
{
	FRCommandClass __parent_class;
};


GtkType      fr_command_tar_get_type        (void);

FRCommand*   fr_command_tar_new             (FRProcess *process,
					     char *filename,
					     FRCompressProgram prog);


#endif /* FR_COMMAND_TAR_H */
