<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).
*/

include_once 'backend/base.inc';
include_once 'pagehead-html.inc';

switch( $HTTP_GET_VARS['order'] )  {
    case 'debit':   $sort = 'debit_acc, credit_acc, nextdue'; break;
    case 'credit':  $sort = 'credit_acc, debit_acc, nextdue'; break;
    case 'value':   $sort = 'value, nextdue'; break;
    case 'desc':    $sort = 'description, nextdue'; break;
    case 'receipt': $sort = 'receipt, nextdue'; break;
    case 'period':  $sort = 'repDays, repMonths';
    default:	    $sort = 'nextdue';
}

$res = $db->query( 'select a1.name,a2.name,value,description,receipt,repDays,repMonths,id,
		    extract(YEAR from nextDue), extract(MONTH from nextDue),
		    extract(DAY from nextDue), extract(HOUR from nextDue),
		    extract(MINUTE from nextDue)
		 from repeated, accounts as a1, accounts as a2
		 where debit_acc = a1.account and credit_acc = a2.account
		 order by '.$sort );
check_res( $res, $LANG_err_readrep );

echo '<h2>', $LANG_menu_rep, "</h2>\n<p>", $LANG_clicktochange, ' ', $LANG_clicksort, "</p>\n";
?>

  <table class="booktbl">
    <tr>
      <th><a href="?order=debit"><?php echo $LANG_debitacc ?></a></th>
      <th><a href="?order=credit"><?php echo $LANG_creditacc ?></a></th>
      <th class="num"><a href="?order=value"><?php echo $LANG_value ?></a></th>
      <th><a href="?order=desc"><?php echo $LANG_desc ?></a></th>
      <th><a href="?order=receipt"><?php echo $LANG_receipt ?></a></th>
      <th><a href="?order=due"><?php echo $LANG_nextdue ?></a></th>
      <th><a href="?order=period"><?php echo $LANG_period ?></a></th>
    </tr>

<?php
while( $row = $res->fetchRow() ) {
    $nextdue = sprintf( '%d-%02d-%02d&nbsp;%02d:%02d', $row[8], $row[9], $row[10], $row[11], $row[12] );
    print "<tr> <td>". htmlq( $row[0] ) . '</td> <td>'
	. htmlq( $row[1] ) . '</td> <td class="num">' . formatval( $row[2] ).
	  '</td> <td><a href="booking.php?repid=' . $row[7] . '">' .
	htmlq( $row[3] ). '</a></td> <td>'
	. $row[4] . '</td> <td>' . $nextdue . '</td> <td>';
    if( $row[5] )
	print( ($row[5] == 1) ? $LANG_daily : $row[5].'&nbsp;'.$LANG_days );
    else
	print( ($row[6] == 1) ? $LANG_monthly : $row[6].'&nbsp;'.$LANG_months );
    print "</td></tr>\n";
}
?>

  </table>
</body>
</html>
