/*  BPropPatchMethod.java
    Copyright (C) 2004 Juhani Rautiainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import java.io.IOException;
import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.*;

public class BPropPatchMethod extends EntityEnclosingMethod {

	//private String body;

	public BPropPatchMethod(String path) {
        	super(path);
    	}

	public String getName() {
		return "BPROPPATCH";
	}

   	public void addRequestHeaders(HttpState state, HttpConnection conn)
    		throws IOException, HttpException {
        	super.addRequestHeaders(state, conn);
		super.addRequestHeader("If-Match","*");
        	super.addRequestHeader("Brief", "t");
        	if (getRequestHeader("Content-Type") == null ) super.setRequestHeader("Content-Type", "text/xml");
        }	
}
