;; ===================================================================================
;; Italian FESTIVAL Modules(IFM)
;; Copyright (C) 2001-2005 by the IFM Development Team
;; at "ISTC-SPFD CNR" and at "ITC-Irst".
;; ===================================================================================
;;	ISTC-SPFD CNR
;;		Istituto di Scienze e Tecnologie della Cognizione
;;		Sezione di Padova "Fonetica e Dialettologia"
;;		Consiglio Nazionale delle Ricerche
;;		Via G. Anghinoni, 10 - 35121 Padova
;;		tel (+39) 049 8274418 - fax (+39) 049 8274416
;;		e-mail: segreteria@pd.istc.cnr.it 
;; 
;;	ITC-irst
;;		Istituto Trentino di Cultura
;;		Centro per la ricerca scientifica e tecnologica 
;;		Via Santa Croce 77 - 38100 Trento ITALIA
;;		tel (+39) 0461-210111 - fax (+39) 0461-980436
;;		e-mail: info@itc.it 
;; ===================================================================================
;; This file is part of IFM.
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;; ===================================================================================
;; Authors:	Piero COSI, ISTC-SPFD CNR, (cosi@pd.istc.cnr.it)
;; 		Carlo DRIOLI
;; 		Graziano TISATO
;; 		Roberto GRETTER, ITC-irst (SSI/MPA), (gretter@itc.it) 
;; 		Fabio TESSER
;; ===================================================================================
;;		WEB:  http://www.pd.istc.cnr.it/TTS/ItalianFESTIVAL
;; ===================================================================================
;;
;; ITALIAN PHONESET
;;
;; ===================================================================================
;;
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Sono stati inseriti i fonemi della lingua italiana usando la notazione SAMPA. ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defPhoneSet
italian
;;; Caratteristiche dei foni
(;; vowel or consonant
   (vc + -)  
   ;; vowel length: short long diphthong schwa
   (vlng s l d a 0)
   ;; vowel height: high mid low
   (vheight 1 2 3 -)
   ;; vowel frontness: front mid back
   (vfront 1 2 3 -)
   ;; lip rounding
   (vrnd + -)
   ;; consonant type: stop fricative affricative nasal liquid
   (ctype s f a n l 0)
   ;; place of articulation: labial alveolar palatal labio-dental dental velar
   (cplace l a p b d v 0)
   ;; consonant voicing
   (cvox + -)
   ;; accentazione
   (acc + - 0)
   ;; geminate: nel senso che il fonema pu o meno geminarsi
   (gem + - 0)
   ;;semivocali/semiconsonanti
   (semi + -)
   )

;;; Insieme dei foni (41 fonemi)

(;;  VOCALI
 (i + s 1 1 - 0 0 - - 0 - )
 (e + s 2 1 - 0 0 - - 0 - ) ;;  e chiusa
 (E + s 2 1 - 0 0 - - 0 - ) ;;  e aperta
 (a + s 3 2 - 0 0 - - 0 - )
 (o + s 2 3 + 0 0 - - 0 - ) ;;  o chiusa
 (O + s 2 3 + 0 0 - - 0 - ) ;;  o aperta 
 (u + s 1 3 + 0 0 - - 0 - )
(i1 + s 1 1 - 0 0 - + 0 - )
(e1 + l 2 1 - 0 0 - + 0 - ) ;;  e chiusa
(E1 + l 2 1 - 0 0 - + 0 - ) ;;  e aperta
(a1 + l 3 2 - 0 0 - + 0 - )
(o1 + l 2 3 + 0 0 - + 0 - ) ;;  o chiusa
(O1 + l 2 3 + 0 0 - + 0 - ) ;;  o aperta 
(u1 + l 1 3 + 0 0 - + 0 - )

;;  SEMI-VOCALI (SEMI-CONSONANTI)
 (j - s 1 1 - 0 0 + - 0 + )
 (w - s 1 3 + 0 0 + - 0 + )

;;  OCCLUSIVE (O PLOSIVE)
 (p - 0 - - - s l - 0 + - )
 (t - 0 - - - s a - 0 + - )
 (k - 0 - - - s v - 0 + - )
 (b - 0 - - - s l + 0 + - )
 (d - 0 - - - s a + 0 + - )
 (g - 0 - - - s v + 0 + - )

;;  FRICATIVE
 (f - 0 - - - f b - 0 + - )
 (s - 0 - - - f a - 0 + - )
 (S - 0 - - - f p - 0 + - )
 (v - 0 - - - f b + 0 + - )
 (z - 0 - - - f a + 0 - - )
 (Z - 0 - - - f p + 0 - - )

;;  AFFRICATE
(ts - 0 - - - a a - 0 + - )
(tS - 0 - - - a p - 0 + - )
(dz - 0 - - - a a + 0 + - )
(dZ - 0 - - - a p + 0 + - )

;;  NASALI
 (m - 0 - - - n l + 0 + - )
 (n - 0 - - - n a + 0 + - )
 (J - 0 - - - n p + 0 + - )
(ng - 0 - - - n v + 0 - - )
(nf - 0 - - - n b + 0 - - )

;;  LIQUIDE (O APPROSSIMANTI)
 (l - 0 - - - l a + 0 + - )
 (L - 0 - - - l p + 0 + - )
 (r - 0 - - - l a + 0 + - )

;;SILENZIO
 (# - 0 - - - 0 0 - 0 0 - )

;;  LE GEMINATE hanno le stesse features delle loro controparti singole. (noi non le usiamo)

)
)

(PhoneSet.silences '(#))

(provide 'italian_phoneset)