/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "ferite.h"

FeriteNamespace *__ferite_register_namespace( FeriteScript *script, char *name, FeriteNamespace *parent )
{ 
   FeriteNamespace *ns = NULL;
   
   FE_ENTER_FUNCTION;
   FE_ASSERT( parent != NULL );
   FE_ASSERT( name != NULL );
   ns = fmalloc( sizeof( FeriteNamespace ) );
   ns->num = FE_NAMESPACE_INIT_SIZE;
   ns->space = __ferite_create_hash( script, FE_NAMESPACE_INIT_SIZE );
   __ferite_register_namespace_element( script, parent, name, FENS_NS, ns );
   FE_LEAVE_FUNCTION( ns );
}

FeriteFunction *__ferite_register_ns_function( FeriteScript *script, FeriteNamespace *ns, FeriteFunction *f )
{
   
   FE_ENTER_FUNCTION;
   FE_ASSERT( ns != NULL );
   FE_ASSERT( f != NULL );
   __ferite_register_namespace_element( script, ns, f->name, FENS_FNC, f );
   FE_LEAVE_FUNCTION( f );
}

FeriteVariable *__ferite_register_ns_variable( FeriteScript *script, FeriteNamespace *ns, FeriteVariable *var )
{
   FE_ENTER_FUNCTION;
   FE_ASSERT( ns != NULL );
   FE_ASSERT( var != NULL );
   FUD(("NS: Adding variable %p\n", var));
   __ferite_register_namespace_element( script, ns, var->name, FENS_VAR, var );
   FE_LEAVE_FUNCTION( var ); 
}

FeriteClass *__ferite_register_ns_class( FeriteScript *script, FeriteNamespace *ns, FeriteClass *classt )
{
   FE_ENTER_FUNCTION;
   FE_ASSERT( ns != NULL );
   FE_ASSERT( classt != NULL );
   __ferite_register_namespace_element( script, ns, classt->name, FENS_CLS, classt );
   FE_LEAVE_FUNCTION( classt );
}

void __ferite_delete_namespace_element( FeriteScript *script, FeriteNamespaceBucket *nsb )
{
   FE_ENTER_FUNCTION;
   FUD(("NS: deleting namespace element %d[%p]\n", nsb->type, nsb));
   switch( nsb->type )
   {
    case FENS_NS:
      __ferite_delete_namespace( script, nsb->data );
      break;
    case FENS_VAR:
      __ferite_variable_destroy( script, nsb->data );
      break;
    case FENS_FNC:
      __ferite_delete_function_list( script, nsb->data );
      break;
    case FENS_CLS:
      __ferite_delete_class( script, nsb->data );
      break;
    default:
      ferite_warning( script, "Trying to delete element of type '%d' from a namespace - Unknown Type", nsb->type );
   }
   ffree( nsb );
   FE_LEAVE_FUNCTION( NOWT );
}

int __ferite_delete_namespace( FeriteScript *script, FeriteNamespace *ns )
{
   FE_ENTER_FUNCTION;
   if( ns != NULL )
   {
      __ferite_delete_hash( script, ns->space, (void (*)(FeriteScript*,void *))__ferite_delete_namespace_element );
      ffree( ns );
   }
   FE_LEAVE_FUNCTION( 1 );
}

FeriteNamespaceBucket *__ferite_register_namespace_element( FeriteScript *script, FeriteNamespace *ns, char *name,
							    int type, void *data )
{
   FeriteNamespaceBucket *nsb = NULL;
   
   FE_ENTER_FUNCTION;
   FE_ASSERT( ns != NULL );
   FE_ASSERT( name != NULL );
   FE_ASSERT( type > 0 );
   FE_ASSERT( data != NULL );
   nsb = fmalloc( sizeof( FeriteNamespaceBucket ) );
   nsb->type = type;
   nsb->data = data;
   __ferite_hash_add( script, ns->space, name, nsb );
   FE_LEAVE_FUNCTION( nsb );
}

FeriteNamespaceBucket *__ferite_namespace_element_exists( FeriteScript *script, FeriteNamespace *ns, char *name )
{
   FeriteNamespaceBucket *nsb = NULL;
   
   FE_ENTER_FUNCTION;
   FE_ASSERT( ns != NULL );
   FE_ASSERT( name != NULL );
   nsb = __ferite_hash_get( script, ns->space, name );
   FE_LEAVE_FUNCTION( nsb );
}

void __ferite_delete_namespace_element_from_namespace( FeriteScript *script, FeriteNamespace *ns, char *name )
{
   FeriteNamespaceBucket *nsb = NULL;
   
   FE_ENTER_FUNCTION;
   FE_ASSERT( ns != NULL );
   FE_ASSERT( name != NULL );
   nsb = __ferite_namespace_element_exists( script, ns, name );
   FE_ASSERT( nsb != NULL );
   __ferite_hash_delete( script, ns->space, name );
   __ferite_delete_namespace_element( script, nsb );
   FE_LEAVE_FUNCTION( NOWT );
}

FeriteNamespaceBucket *__ferite_find_namespace( FeriteScript *script, FeriteNamespace *parent, char *obj, int type )
{
   FeriteNamespaceBucket *nsb = NULL;
   char *buf;
   int i = 0;
   
   FE_ENTER_FUNCTION;
   FE_ASSERT( parent != NULL );
   FE_ASSERT( obj != NULL );
   
   if( __ferite_find_string( obj, "." ) == -1 )
   { /* we need not split the string up */
      nsb = __ferite_namespace_element_exists( script, parent, obj );
	  if( type > 0 ){
		 if( nsb == NULL || nsb->type != type )
		 {
			FE_LEAVE_FUNCTION( NULL );
		 } 
	  } 
	  FE_LEAVE_FUNCTION( nsb );
   }
   else
   { /* we need to split the string up */
	  buf = memset( fmalloc( strlen(obj)+1 ), '\0', strlen(obj) );
	  for( i = 0; obj[i] != '.'; i++ );
	  strncpy( buf, obj, i );
	  FUD(( "obj: '%s', buf: '%s', pass-down: '%s'\n", obj, buf, obj+i+1 ));
	  nsb = __ferite_namespace_element_exists( script, parent, buf );
	  ffree( buf );
	  if( nsb->type != FENS_NS ){
		 FE_LEAVE_FUNCTION( NULL );
	  }
	  FE_LEAVE_FUNCTION( __ferite_find_namespace( script, nsb->data, obj+i+1, type ) );		 
   }
   FE_LEAVE_FUNCTION( NULL );
}

