/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  network_Socket.c */
/* class: Socket */

#include <ferite.h>       /* we need this without a doubt */
#include "network_header.h"  /* this is the module header */

FE_NS_FUNCTION( network_Socket_write )
{
   char *data = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, data, &super, &self );

   { /* Main function body. */
 
      size_t		nleft;
      ssize_t		nwritten;
      char		*iter;
      int		fd;

      fd = SelfObj->sockfd;
      iter = data;
      nleft = strlen(iter);

      while( nleft > 0 )
      {
         if ( (nwritten = write(fd, iter, nleft)) <= 0)
         {
            ferite_error( script, "Couldn't write stuff" );
            break;
         }
         nleft -= nwritten;
         iter  += nwritten;
      }
      ffree(data);
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_getHostname )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  FeriteVariable *var = fe_new_str( "Socket->getHostname()", SelfObj->hostname );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_close )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
      SelfObj->connected = 0;
      close( SelfObj->sockfd );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_setRecvTimeouts )
{
   double seconds;
   double uSeconds;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, &seconds, &uSeconds, &super, &self );

   { /* Main function body. */
 
	  SelfObj->seconds = (long)seconds;
	  SelfObj->uSeconds = (long)uSeconds;
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_getPort )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  FE_RETURN_LONG( SelfObj->port );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_recv )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  struct timeval wait_for_info;
	  fd_set readfds;
	  int    result;
	  char   buf[8096], *tmpBuf;
	  
	  wait_for_info.tv_sec = SelfObj->seconds;
	  wait_for_info.tv_usec = SelfObj->uSeconds; /* wait only for a uSec */
	  
	  FD_ZERO( &readfds );
	  FD_SET( SelfObj->sockfd, &readfds );
	  result = select( SelfObj->sockfd+1, &readfds, NULL, NULL, &wait_for_info );
	  if( result >= 0 )
	  {
		 if( FD_ISSET( SelfObj->sockfd, &readfds ) )/* wh00p we have some data */
		 {
			memset( buf, 0, 8096 );
			result = recv( SelfObj->sockfd, buf, 8096, 0 );
			if( result > 0 )
			{
			   if( (SelfObj->buffer_size - strlen( SelfObj->buffer )) > strlen( buf ) )
			   { /* we have enough space in SelfObj->buffer */
				  strcat( SelfObj->buffer, buf );
			   } else { /* we need to change the buffer size */
				  tmpBuf = fmalloc( SelfObj->buffer_size + strlen( buf ) + 1 );
				  memset( tmpBuf, '\0', SelfObj->buffer_size + strlen( buf ) + 1 );
				  strcpy( tmpBuf, SelfObj->buffer );
				  strcat( tmpBuf, buf );
				  ffree( SelfObj->buffer );
				  SelfObj->buffer = tmpBuf;
				  SelfObj->buffer_size = (SelfObj->buffer_size + strlen( buf ) + 1 );
			   }
			} else {
			   if( result == 0 ){
				  ferite_error( script, "Remote side closed connection (%s)", SelfObj->hostname );
			   } else {
				  ferite_error( script, "Error whilst reading from socket (%s)", SelfObj->hostname );
			   }
			}
		 }
	  } else {
		 ferite_error( script, "Select fouled up on socket. (%s)\n", SelfObj->hostname );
	  }
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_getBuffer )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  FeriteVariable *var  = fe_new_str( "buffer-length", SelfObj->buffer );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_read )
{
   double length;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &length, &super, &self );

   { /* Main function body. */
 
	  FeriteVariable **recvParams = NULL;
	  FeriteVariable *var;
	  char *buffer = memset( fmalloc( length+1 ), '\0', (long)length+1 );
	  
	  recvParams = params;
	  recvParams += sizeof( FeriteVariable );
	  __ferite_variable_destroy( script, network_Socket_recv( script, recvParams ) );
	  
	  if( strlen( SelfObj->buffer ) < (long)length ){ /* all of the buffer */
		 strncpy( buffer, SelfObj->buffer, strlen( SelfObj->buffer ) );
		 memset( SelfObj->buffer, '\0', SelfObj->buffer_size );
	  } else { /* only part of it */
		 strncpy( buffer, SelfObj->buffer, (long)length );
		 memmove( SelfObj->buffer, SelfObj->buffer + (long)length, SelfObj->buffer_size - (long)length );
	  }
	  
	  var = fe_new_str( "Socket->read-return", buffer );
	  ffree( buffer );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_connect )
{
   char *host = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   double port;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, host, &port, &super, &self );

   { /* Main function body. */
 
      struct sockaddr_in	serv_addr;
      struct hostent		*hostent_ptr;

      if( SelfObj->hostname != NULL )
        ffree( SelfObj->hostname );
      SelfObj->hostname = host;
      SelfObj->port = (long)port;
      
      SelfObj->sockfd = socket( SelfObj->domain, SelfObj->type, SelfObj->protocol );
      if( SelfObj->sockfd < 0 )
      {
         ferite_error( script,"Unable to create socket.");
         FE_RETURN_VOID;
      }
      memset( (char*)&serv_addr, '\0', sizeof(serv_addr) );

      /* Need to lookup addr in case it's not a dot-ip */
      hostent_ptr = gethostbyname(SelfObj->hostname);
      if(!hostent_ptr)
      {
         ferite_error( script,"Couldn't lookup host %s.", SelfObj->hostname);
         FE_RETURN_VOID;
      }

      serv_addr.sin_family = SelfObj->transport;
      memcpy(&serv_addr.sin_addr, hostent_ptr->h_addr, sizeof(serv_addr.sin_addr));
      serv_addr.sin_port = htons(SelfObj->port);

      if(connect( SelfObj->sockfd, (struct sockaddr*) &serv_addr, sizeof(serv_addr)) < 0)
      {
         ferite_error( script,"Couldn't connect to host %s:%d.", SelfObj->hostname, SelfObj->port);
         FE_RETURN_VOID;
      }
      SelfObj->connected = 1;
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_Socket )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
      SelfObj = fmalloc( sizeof(SocketData) );
      SelfObj->sockfd = 0;
      SelfObj->buffer = memset( fmalloc( 1024 ), '\0', 1024 );
      SelfObj->buffer_size = 1024;
      SelfObj->hostname = NULL;
      SelfObj->port = 0;      
      SelfObj->transport = AF_INET;
      SelfObj->domain = PF_INET;
      SelfObj->type = SOCK_STREAM;
      SelfObj->protocol = 0;
      SelfObj->connected = 0;
      SelfObj->seconds = 0;
      SelfObj->uSeconds = 1;
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_readln )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  FeriteVariable *var;
	  char *buffer = NULL;
	  long length = 0;

	  do { /* we block until we have a line of data */
		 __ferite_variable_destroy( script, network_Socket_recv( script, params ) );
	  } while ( (length = __ferite_find_string( SelfObj->buffer, "\n" )) == -1 && script->error_state == 0);
	  
	  if( script->error_state == 0 ){
		 buffer = memset( fmalloc( length+1 ), '\0', length+1 );	  
		 strncpy( buffer, SelfObj->buffer, length );
		 if( buffer[strlen(buffer)-1] == '\r' )
		   buffer[strlen(buffer)-1] = '\0';
		 memmove( SelfObj->buffer, SelfObj->buffer + length + 1, SelfObj->buffer_size - length );	 
		 var = fe_new_str( "Socket->read-return", buffer );
		 ffree( buffer );
	  } else {
		 var = fe_new_str( "Socket->read-return", "" );
	  }
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_Destructor )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
      close( SelfObj->sockfd );
      if( SelfObj->buffer != NULL )
        ffree( SelfObj->buffer );
      if( SelfObj->hostname != NULL )
        ffree( SelfObj->hostname );
      ffree( SelfObj );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_isConnected )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  if( SelfObj->connected )
	  {
		 FE_RETURN_TRUE;
	  }
	  FE_RETURN_FALSE;
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( network_Socket_dataWaiting )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	  if( strlen( SelfObj->buffer ) > 0 )
	  {
		 FE_RETURN_TRUE;
	  }
	  FE_RETURN_FALSE;
   
   }
   FE_RETURN_VOID;
}

