/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  ipc_IpcObject.c */
/* class: IpcObject */

#include <ferite.h>       /* we need this without a doubt */
#include "ipc_header.h"  /* this is the module header */

FE_NS_FUNCTION( ipc_IpcObject_write )
{
   char *msg = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, msg, &super, &self );

   { /* Main function body. */
 
        union semun arg;

        
        /* TEST - remove me */
        printf("Trying to lock\n");


        /* increment the readers semaphore where they'll be waiting for
         * it to get to 0 again
         */
        arg.val = 1;
        if (semctl(SelfObj->semid, 1, SETVAL, arg) == -1) {
            ferite_error (script, "Could not set the readers sem from write");
            FE_RETURN_VOID;
        }


        /* wait on the writers semaphore */
        SelfObj->sembuffer.sem_num = 0;
        SelfObj->sembuffer.sem_op = -1; // {0, -1, 0}
        if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1) {
            ferite_error (script, "Unable to lock writer semaphore");
            FE_RETURN_VOID;
        }

        
        /* TEST - remove me */
        printf ("Locked ...\n");

        
        strncpy (SelfObj->data, msg, SelfObj->size);
        ffree(msg);


        /* TEST - remove me */
        printf("Hit enter to unlock");
        getchar();
        /* TEST END */
        
        
        /* unlock writer semaphore */
        SelfObj->sembuffer.sem_num = 0;
        SelfObj->sembuffer.sem_op = 1; // {0, 1, 0}
        if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1) {
            ferite_error (script, "Unable to unlock the writer semaphore.");
            FE_RETURN_VOID;
        }


        /* if there is no more writers it is our job to signal the
         * readers.
         */
        if ((int)semctl(SelfObj->semid, 0, GETNCNT, &arg) == 0) {
            
            /* unleash the readers */
            arg.val = 0;
            if (semctl(SelfObj->semid, 1, SETVAL, arg) == -1) {
                ferite_error (script, "Could not unleash the readers.");
                FE_RETURN_VOID;
            }
        }

       
        /* TEST - remove me */
        printf ("Unlocked");
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( ipc_IpcObject_disconnect )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
        struct shmid_ds buf;
        union semun dummy;
        
        /* first check to see if I'm connected */
        if (!SelfObj->connected) {
            ferite_error (script, "I am not connected");
            FE_RETURN_VOID;
        } 

        
        /* detatch from the shm */
        if (shmdt(SelfObj->data) == -1) {
             ferite_error( script, "shm detach failed");
             FE_RETURN_VOID;
        }



        /* need to pick up some info in the shm's status */
        if (shmctl(SelfObj->shmid, IPC_STAT, &buf) == -1) {
            ferite_error (script, "could not get shm stat");
            FE_RETURN_VOID;
        }   

        /* 
         * If I'm the last process connected to the shm I have to 
         * delete the shared memory segment and semaphore set
         */
        if (buf.shm_nattch == 0) {
            if (shmctl(SelfObj->shmid, IPC_RMID, NULL) == -1) {
                 ferite_error (script, "Could not delete shm or mark it for deletion");
                 FE_RETURN_VOID;
             }
             if (semctl(SelfObj->semid, IPC_RMID, 0, dummy) == -1) {
                 ferite_error(script, "Could not delete the semaphore set");
                 FE_RETURN_VOID;
            }
        }
    
        SelfObj->connected = 0;
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( ipc_IpcObject_IpcObject )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
        SelfObj = fmalloc (sizeof(IpcData));
        SelfObj->key = 0;
        SelfObj->size = DEFAULT_SEGMENT_SIZE;
        SelfObj->perm = DEFAULT_PERMISSION;
        SelfObj->shmflag = 0;
        SelfObj->connected = 0;
        SelfObj->sembuffer.sem_flg = 0;
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( ipc_IpcObject_read )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
        union semun arg;
        FeriteVariable *var;
        char *buffer = memset (fmalloc (strlen(SelfObj->data) +1), '\0', (long)strlen(SelfObj->data) +1);

       
        /* check to see if anyone wants to write */
        if ((int)semctl(SelfObj->semid, 1, GETVAL, &arg) == 1) {

            printf("Waiting on writers\n");    

            /* wait for the writers */
            SelfObj->sembuffer.sem_num = 1;
            SelfObj->sembuffer.sem_op = 0;
            
            if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1) {
                ferite_error (script, "Unable to wait on writers");
                FE_RETURN_VOID;
            }
        }
        
        
        
        /* if no one is currently reading it is our job to lock out the writers */
        if ((int)semctl(SelfObj->semid, 2, GETVAL, &arg) == 0) {
            /* lock out the writers */
            SelfObj->sembuffer.sem_num = 0;
            SelfObj->sembuffer.sem_op = -1;  // {0, -1, 0}
            if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1) {
                feriter_error (script, "Unable to lock writers semaphore.");
                FE_RETURN_VOID;
            }
       }

        /* increment readcount semaphore */
        SelfObj->sembuffer.sem_num = 2;
        SelfObj->sembuffer.sem_op = 1;
        if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1) {
            ferite_error (script, "Unable to increment readcount semaphore.");
            FE_RETURN_VOID;
        }


        strncpy (buffer, SelfObj->data, strlen(SelfObj->data));
        var = fe_new_str( "Ipc->read-return", buffer);
        ffree(buffer);
        

        printf("Reading...\nHit enter to exit\n");
        getchar();

        
        /* decrement readcount semaphore */
        SelfObj->sembuffer.sem_num = 2;
        SelfObj->sembuffer.sem_op = -1;
        if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1) {
            ferite_error (script, "Could not decrement readcount semaphore");
            FE_RETURN_VOID;
        }

        
        /* if there's no more readers it is our job to signal the writers */
        if ((int)semctl(SelfObj->semid, 2, GETVAL, &arg) == 0) {
            
            SelfObj->sembuffer.sem_num = 0;
            SelfObj->sembuffer.sem_op = 1;
            if (semop(SelfObj->semid, &SelfObj->sembuffer, 1) == -1) {
                ferite_error (script, "Could not unlock writers semaphore");
                FE_RETURN_VOID;
            }
        }


        FE_RETURN_VAR (var);
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( ipc_IpcObject_connect )
{
   char *file = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, file, &super, &self );

   { /* Main function body. */
 

        union semun arg;
        arg.val = 1;
        
        /* create a key for the shm */
        SelfObj->key = ftok (file, 'E');
            if (SelfObj->key == -1) {
			    ffree (file);
                ferite_error (script, "Unable to create shm key.");
                FE_RETURN_VOID;
            }


        /* don't need this string anymore so free it */
	    ffree (file);


        
        /*
         * this tests if the shm already exists
         * If the shm does not exist we need to make a semaphore set
         * with 2 semaphores control read/write access to the shm
         */
        SelfObj->shmid = shmget (SelfObj->key,
                                SelfObj->size,
                                SelfObj->perm | IPC_EXCL | IPC_CREAT);
        if (SelfObj->shmid != -1) {

            /* 
             * Create a semaphore set for access control to
             * the shm
             */
            SelfObj->semid = semget (SelfObj->key, 3, SelfObj->perm | IPC_CREAT);
            if (SelfObj->semid == -1) {
                ferite_error (script, "Unable to create semaphore.");
                FE_RETURN_VOID;
            }
            
            /* initialize the writer semaphores to 1 */
            if (semctl(SelfObj->semid, 0, SETVAL, arg) == -1) {
                ferite_error (script, "Unable to set semaphore 1");
                FE_RETURN_VOID;
            }
            /* initialize the reader semaphore to 0 */
            arg.val = 0;
            if (semctl(SelfObj->semid, 1, SETVAL, arg) == -1) {
                ferite_error (script, "Unable to set semaphore 2");
                FE_RETURN_VOID;
            }

            /* set readcount semaphore to 0 */
            if (semctl(SelfObj->semid, 2, SETVAL, arg) == -1) {
                ferite_error (script, "Unable to set semaphore 3");
                FE_RETURN_VOID;
            }
        }




        /* Grab the semaphore set id */
        SelfObj->semid = semget (SelfObj->key, 2, 0);
            if (SelfObj->semid == -1) {
                ferite_error (script, "Unable to grab the semaphore.");
                FE_RETURN_VOID;
            }
        
        /* 
         * create the shm and get it's id 
         * if an shm with this id already exist just connect to it
         */
        SelfObj->shmid = shmget (SelfObj->key, 
                                SelfObj->size,
                                SelfObj->perm | IPC_CREAT);
            if (SelfObj->shmid == -1) {
                ferite_error (script, "Unable to get shm id.");
                FE_RETURN_VOID;
            } 
        
        
        /* attach the data pointer to the shm */
        SelfObj->data = shmat (SelfObj->shmid, (void *)0, 0);
            if (SelfObj->data == (char*)(-1)) {
                ferite_error (script, "Unable to attach to the shm");
                FE_RETURN_VOID;
            }

        
        SelfObj->connected = 1;
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( ipc_IpcObject_Destructor )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
        struct shmid_ds buf;
        union semun dummy;
        
        if (SelfObj->connected)
        {
            /* detatch from the shm */
            if (shmdt(SelfObj->data) == -1)
                ferite_error (script, "shm detach failed");

            if (shmctl(SelfObj->shmid, IPC_STAT, &buf) == -1)
                feriter_error (script, "could not stat shm");
            else {
                /* am I the last process connected to it */
                if (buf.shm_nattch == 0) {
                    /* destroy shm */
                    if (shmctl(SelfObj->shmid, IPC_RMID, NULL) == -1)
                        ferite_error (script, "could not delete the shm");

                    /* destroy the semaphore */
                    if (semctl(SelfObj->semid, IPC_RMID, 0, dummy) == -1)
                        ferite_error (script, "could not delete the sem set");
                }
            }   
        }
            
        ffree (SelfObj);
    
   }
   FE_RETURN_VOID;
}

