/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  file_UnixsockServer.c */
/* class: UnixsockServer */

#include <ferite.h>       /* we need this without a doubt */
#include "file_header.h"  /* this is the module header */

FE_NS_FUNCTION( file_UnixsockServer_accept )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   int		newfd;
	   FeriteVariable	*newClient, **newParams;
	   FileData	*newObject;
	   
	   errno=0;
	   newfd = accept( FileObj->fd, 0, 0);
	   FileObj->err=errno;
	   if(newfd==-1)
	   {
		  /*  Create a BAD client..  */
		  /* pfv: newClient= __ferite_create_object_variable( "badClient" );  */
		  ExtendedException("UnixsockServer","sockAccept()");
		  
	   }
	   else
	   {
		  /*  Create a GOOD client  */
		  newParams=  fmalloc( sizeof(FeriteVariable*) * 3 );
		  memset( newParams, 0, sizeof(FeriteVariable*) * 3 );
		  newClient=  __ferite_new_object( script,
										   __ferite_find_class( script, script->mainns, "File" ),
										   newParams );
		  __ferite_delete_parameter_list( script, newParams);
		  
		  newObject=			OAF(VAO(newClient));
		  newObject->fd=		newfd;
		  newObject->fp=		fdopen( newObject->fd, "r+" );
		  newObject->err=		0;
		  newObject->sock=		1;
		  newObject->pathspec=	fstrdup(FileObj->pathspec);
		  newObject->modes=	        fstrdup("aclient");
		  if(!newObject->pathspec || !newObject->modes)
		  {
			 FileRecycle( newObject );
			 ffree( newClient );
			 FileObj->err=ENOMEM;
			 /* pfv newClient= __ferite_create_object_variable( "badClient" );  */
			 ExtendedException("UnixsockServer","accept():Allocation-");
		  }
	   }
	   FE_RETURN_VAR( newClient );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_UnixsockServer_UnixsockServer )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   FeriteVariable **params = __ferite_create_parameter_list_from_data( script, "oo", self, self );
	   __ferite_object_call_super( script, self, params );
	   __ferite_delete_parameter_list( script, params );
	
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_UnixsockServer_open )
{
   char *filename = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   char *mask = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, filename, mask, &super, &self );

   { /* Main function body. */
 
	   int perms;
	   
	   FileRecycle( FileObj );
	   if(*mask)
	   { 
		  char *ow, *gr, *ot;
		  ow=gr=ot=0;
		  ow=mask;
		  gr= (strlen(mask)>3 ? mask+3 : 0);
		  ot= (strlen(mask)>6 ? mask+6 : 0);
		  perms= perm2int( ow, gr, ot);
	   }
	   ffree( mask );
	   
	   errno=0;
	   FileObj->fd= makeSocket(filename, perms, 1);
	   if( FileObj->fd<0 )
	   {
		  FileObj->err=errno;
		  FE_RETURN_LONG( (long)FileObj->err );
	   }
	   
	   FileObj->pathspec= fstrdup(filename);
	   FileObj->modes=	   fstrdup("server");
	   ffree( filename );
	   if(!FileObj->pathspec || !FileObj->modes)
	   {
		  FileRecycle( FileObj );
		  FileObj->err=ENOMEM;
		  FE_RETURN_LONG( (long)FileObj->err );
	   }
	   
	   FileObj->fp=	fdopen( FileObj->fd, "r+" );
	   FileObj->err=	0;
	   FileObj->sock=	FileObj->serv=	1;
	   FE_RETURN_LONG( (long)FileObj->err );
	
   }
   FE_RETURN_VOID;
}

