/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __FERITE_NS_H__
#define __FERITE_NS_H__

#define FENS_NS  1
#define FENS_VAR 2
#define FENS_FNC 3
#define FENS_CLS 4

FeriteNamespace *__ferite_register_namespace( FeriteScript *script,  char *name, FeriteNamespace *parent );
int __ferite_delete_namespace( FeriteScript *script,  FeriteNamespace *ns );
FeriteNamespaceBucket *__ferite_register_namespace_element( FeriteScript *script,  FeriteNamespace *ns, char *name,
							   int type, void *data );
FeriteNamespaceBucket *__ferite_namespace_element_exists( FeriteScript *script,  FeriteNamespace *ns, char *name );
FeriteNamespaceBucket *__ferite_find_namespace( FeriteScript *script,  FeriteNamespace *parent, char *obj, int type );
void __ferite_delete_namespace_element_from_namespace( FeriteScript *script,  FeriteNamespace *ns, char *name );

FeriteFunction *__ferite_register_ns_function( FeriteScript *script,  FeriteNamespace *ns, FeriteFunction *f );
FeriteVariable *__ferite_register_ns_variable( FeriteScript *script,  FeriteNamespace *ns, FeriteVariable *var );
FeriteClass *__ferite_register_ns_class( FeriteScript *script, FeriteNamespace *ns, FeriteClass *classt );


#endif /* __FERITE_NS_H__ */
