/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __FERITE_MEMORY_H__
#define __FERITE_MEMORY_H__

#define fmalloc( size )       (__ferite_malloc)( size, __FILE__, __LINE__ )
#define fcalloc( a, b )       (__ferite_calloc)( a, b, __FILE__, __LINE__ )
#define ffree( ptr )          (__ferite_free)( ptr, __FILE__, __LINE__ ); ptr = NULL
#define frealloc( ptr, size ) (__ferite_realloc)( ptr, size );

void  __ferite_classic_memory_init(void);
void  __ferite_classic_memory_deinit(void);
void *__ferite_classic_malloc( size_t size, char *name, int line );
void *__ferite_classic_calloc( size_t size, size_t blk_size, char *name, int line );
void *__ferite_classic_realloc( void *ptr, size_t size );
void  __ferite_classic_free( void *ptr, char *file, int line );
void __ferite_classic_memory_dump();  

#endif /* __FERITE_MEMORY_H__ */
