/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef _STDIO_H_INCLUDED
#define _STDIO_H_INCLUDED

#include "compiler.h"

extern int putchar(int c);

extern void putcstr(CONST char *str);
extern void putdec(int ndigits, int n);
extern void puthex(int ndigits, unsigned int n);

/*
 * Note: In contrast to what you're used from C, the "%s" output conversion
 * requires TWO parameters in C. So a printf for a string will usually look
 * like this:
 * char bla[] = "test";
 * printf("%s\n", PTR_SEG(bla), PTR_OFF(bla));
 */
extern void
printf(const char *fmt, ...);
extern void
dprintf(const char *fmt, ...);

#endif /* _STDIO_H_INCLUDED */
