/*
 * $Id: chassis_gui_gtk.c,v 1.21 2009-08-24 10:02:42 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-led.h"
#include "glue-gui-gtk-button.h"

#include "chassis_gui_gtk.h"

#define COMP "chassis"

struct cpssp {
	GtkWidget *power_led;
	GtkWidget *ide_led;
	GtkWidget *power_button;
	GtkWidget *reset_button;

	struct sig_boolean *port_mech_power_button;
	struct sig_boolean *port_mech_reset_button;
};

/*
 * Simulator Callbacks
 */
static void
gui_chassis_opt_power_led_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_led_set(GUI_GTK_LED(cpssp->power_led), val);
	gui_gtk_flush();
}

static void
gui_chassis_opt_ide_led_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_led_set(GUI_GTK_LED(cpssp->ide_led), val);
	gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
static void
gui_chassis_power_button_press_event(GtkWidget *w, void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_mech_power_button, cpssp, 1);
}

static void
gui_chassis_power_button_release_event(GtkWidget *w, void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_mech_power_button, cpssp, 0);
}

static void
gui_chassis_reset_button_press_event(GtkWidget *w, void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_mech_reset_button, cpssp, 1);
}

static void
gui_chassis_reset_button_release_event(GtkWidget *w, void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_mech_reset_button, cpssp, 0);
}

void *
chassis_gui_gtk_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_mech_power_button,
	struct sig_std_logic *port_n_power_button,
	struct sig_boolean *port_mech_reset_button,
	struct sig_std_logic *port_n_reset_button,
	struct sig_boolean *port_power_led,
	struct sig_boolean *port_opt_power_led,
	struct sig_boolean *port_ide_led,
	struct sig_boolean *port_opt_ide_led,
	struct sig_sound *port_speaker,
	struct sig_sound *port_audio_speaker
)
{
	static const struct sig_boolean_funcs opt_power_led_funcs = {
		.set = gui_chassis_opt_power_led_set,
	};
	static const struct sig_boolean_funcs opt_ide_led_funcs = {
		.set = gui_chassis_opt_ide_led_set,
	};
	struct cpssp *cpssp;
	GtkWidget *vbox;
	GtkWidget *hbox;


	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	vbox = gtk_vbox_new(FALSE, 1);

	hbox = gtk_hbox_new(FALSE, 1);

	/* Power LED */
	cpssp->power_led = gui_gtk_led_new("Power");
	gtk_widget_show(cpssp->power_led);
	gtk_box_pack_start(GTK_BOX(hbox), cpssp->power_led, TRUE, FALSE, 10);

	/* IDE Busy LED */
	cpssp->ide_led = gui_gtk_led_new("IDE");
	gtk_widget_show(cpssp->ide_led);
	gtk_box_pack_start(GTK_BOX(hbox), cpssp->ide_led, TRUE, FALSE, 10);

	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);

	hbox = gtk_hbox_new(FALSE, 1);

	/* Power Button */
	cpssp->power_button = gui_gtk_button_new("Power");
	g_signal_connect(G_OBJECT(cpssp->power_button), "button-pressed",
			G_CALLBACK(gui_chassis_power_button_press_event), cpssp);
	g_signal_connect(G_OBJECT(cpssp->power_button), "button-released",
			G_CALLBACK(gui_chassis_power_button_release_event), cpssp);
	gtk_widget_show(cpssp->power_button);
	gtk_box_pack_start(GTK_BOX(hbox), cpssp->power_button, TRUE, FALSE, 0);

	/* Reset Button */
	cpssp->reset_button = gui_gtk_button_new("Reset");
	g_signal_connect(G_OBJECT(cpssp->reset_button), "button-pressed",
			G_CALLBACK(gui_chassis_reset_button_press_event), cpssp);
	g_signal_connect(G_OBJECT(cpssp->reset_button), "button-released",
			G_CALLBACK(gui_chassis_reset_button_release_event), cpssp);
	gtk_widget_show(cpssp->reset_button);
	gtk_box_pack_start(GTK_BOX(hbox), cpssp->reset_button, TRUE, FALSE, 0);

	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);

	gtk_widget_show(vbox);
	gui_gtk_comp_add(page, COMP, name, vbox, FALSE, FALSE, NULL);

	/* Out */
	cpssp->port_mech_power_button = port_mech_power_button;
	sig_boolean_connect_out(port_mech_power_button, cpssp, 0);

	cpssp->port_mech_reset_button = port_mech_reset_button;
	sig_boolean_connect_out(port_mech_reset_button, cpssp, 0);

	/* In */
	sig_boolean_connect_in(port_opt_power_led, cpssp, &opt_power_led_funcs);
	sig_boolean_connect_in(port_opt_ide_led, cpssp, &opt_ide_led_funcs);

	return cpssp;
}

void
chassis_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
