/*
 * $Id: sig_string.c,v 1.11 2009-05-21 16:38:09 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "sig_string.h"

void
sig_string_set(struct sig_string *b, void *s, const char *str)
{
	unsigned int nr;

	for (nr = 0; nr < b->member_count; nr++) {
		if (b->member[nr].s == s
		 || ! b->member[nr].f
		 || ! b->member[nr].f->set) {
			continue;
		}
		(*b->member[nr].f->set)(b->member[nr].s, str);
	}
}

void
sig_string_connect(
	struct sig_string *b,
	void *s,
	const struct sig_string_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_STRING);
	assert(b->member_count < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->member_count].s = s;
	b->member[b->member_count].f = f;
	b->member_count++;
}

struct sig_string *
sig_string_create(const char *name)
{
	struct sig_string *b;

	b = malloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_STRING;
	b->member_count = 0;

	return b;
}

void
sig_string_destroy(struct sig_string *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_STRING);

	free(sig);
}
