/*
 * $Id: sig_vga.h,v 1.17 2009-05-21 16:38:09 vrsieh Exp $
 *  
 *  Implementation of the VGA cable.
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_VGA_H_INCLUDED
#define __SIG_VGA_H_INCLUDED

#include "sig_gen.h"
#include "sig_video.h"
#include "sig_i2c_bus.h"

struct sig_vga {
	enum sig_gen_type type;
	/** video signal in vga cable */
	struct sig_video *video;
	/** ddc (i2c bus) signal in vga cable */
	struct sig_i2c_bus *ddc;
};

extern struct sig_vga *
sig_vga_create(const char *name);
extern void
sig_vga_destroy(struct sig_vga *sig);

#endif /* __SIG_VGA_H_INCLUDED */
