/*
 * $Id: sig_icc_bus.c,v 1.13 2009-05-21 16:38:07 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "fixme.h"

#include "sig_icc_bus.h"

void
sig_icc_bus_eoi(
	struct sig_icc_bus *b,
	void *s,
	uint8_t vector
)
{
	unsigned int nr;
	void (*func)(void *, uint8_t);

	for (nr = 0; nr < b->nmembers; nr++) {
		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->eoi;
		if (func != 0) {
			func(b->member[nr].s, vector);
		}
	}
}

void
sig_icc_bus_msg0(
	struct sig_icc_bus *b, void *s,
	unsigned int destination_mode,
	unsigned int delivery_mode,
	unsigned int level,
	unsigned int trigger_mode,
	uint8_t vector,
	uint8_t destination
)
{
	unsigned int nr;
	void (*func)(void *, unsigned int, unsigned int,
			unsigned int, unsigned int, uint8_t, uint8_t);

	for (nr = 0; nr < b->nmembers; nr++) {
		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->msg0;
		if (func != 0) {
			func(b->member[nr].s, destination_mode,
					delivery_mode, level,
					trigger_mode, vector, destination);
		}
	}
}

void
sig_icc_bus_status0(
	struct sig_icc_bus *b,
	void *s,
	unsigned int status
)
{
	unsigned int nr;
	void (*func)(void *, unsigned int);

	for (nr = 0; nr < b->nmembers; nr++) {
		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->status0;
		if (func != 0) {
			func(b->member[nr].s, status);
		}
	}
}

void
sig_icc_bus_msg1(
	struct sig_icc_bus *b,
	void *s,
	uint8_t processor_priority
)
{
	unsigned int nr;
	void (*func)(void *, uint8_t);

	for (nr = 0; nr < b->nmembers; nr++) {
		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->msg1;
		if (func != 0) {
			func(b->member[nr].s, processor_priority);
		}
	}
}

void
sig_icc_bus_status1(
	struct sig_icc_bus *b,
	void *s,
	unsigned int status
)
{
	unsigned int nr;
	void (*func)(void *, unsigned int);

	for (nr = 0; nr < b->nmembers; nr++) {
		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->status0;
		if (func != 0) {
			func(b->member[nr].s, status);
		}
	}
}

void
sig_icc_bus_connect(
	struct sig_icc_bus *b,
	void *s,
	const struct sig_icc_bus_funcs *f
)
{
	assert(b);
	assert(b->type = SIG_GEN_ICC_BUS);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

static void
sig_icc_bus_s0_eoi(void *_f, uint8_t vector)
{
	struct sig_icc_bus_merge *f = (struct sig_icc_bus_merge *) _f;

	sig_icc_bus_eoi(f->s1, f, vector);
}

static void
sig_icc_bus_s0_msg0(
	void *_f,
	unsigned int destination_mode,
	unsigned int delivery_mode,
	unsigned int level,
	unsigned int trigger_mode,
	uint8_t vector,
	uint8_t destination
)
{
	struct sig_icc_bus_merge *f = (struct sig_icc_bus_merge *) _f;

	sig_icc_bus_msg0(f->s1, f, destination_mode, delivery_mode,
			level, trigger_mode, vector, destination);
}

static void
sig_icc_bus_s0_status0(void *_f, unsigned int status)
{
	struct sig_icc_bus_merge *f = (struct sig_icc_bus_merge *) _f;

	sig_icc_bus_status0(f->s1, f, status);
}

static void
sig_icc_bus_s0_msg1(void *_f, uint8_t processor_priority)
{
	struct sig_icc_bus_merge *f = (struct sig_icc_bus_merge *) _f;

	sig_icc_bus_msg1(f->s1, f, processor_priority);
}

static void
sig_icc_bus_s0_status1(void *_f, unsigned int status)
{
	struct sig_icc_bus_merge *f = (struct sig_icc_bus_merge *) _f;

	sig_icc_bus_status1(f->s1, f, status);
}

static void
sig_icc_bus_s1_eoi(void *_f, uint8_t vector)
{
	struct sig_icc_bus_merge *f = (struct sig_icc_bus_merge *) _f;

	sig_icc_bus_eoi(f->s0, f, vector);
}

static void
sig_icc_bus_s1_msg0(
	void *_f,
	unsigned int destination_mode,
	unsigned int delivery_mode,
	unsigned int level,
	unsigned int trigger_mode,
	uint8_t vector,
	uint8_t destination
)
{
	struct sig_icc_bus_merge *f = (struct sig_icc_bus_merge *) _f;

	sig_icc_bus_msg0(f->s0, f, destination_mode, delivery_mode,
			level, trigger_mode, vector, destination);
}

static void
sig_icc_bus_s1_status0(void *_f, unsigned int status)
{
	struct sig_icc_bus_merge *f = (struct sig_icc_bus_merge *) _f;

	sig_icc_bus_status0(f->s0, f, status);
}

static void
sig_icc_bus_s1_msg1(void *_f, uint8_t processor_priority)
{
	struct sig_icc_bus_merge *f = (struct sig_icc_bus_merge *) _f;

	sig_icc_bus_msg1(f->s0, f, processor_priority);
}

static void
sig_icc_bus_s1_status1(void *_f, unsigned int status)
{
	struct sig_icc_bus_merge *f = (struct sig_icc_bus_merge *) _f;

	sig_icc_bus_status1(f->s0, f, status);
}

struct sig_icc_bus_merge *
sig_icc_bus_merge(
	struct sig_icc_bus *s0,
	struct sig_icc_bus *s1
)
{
	static const struct sig_icc_bus_funcs s0_funcs = {
		.eoi = sig_icc_bus_s0_eoi,
		.msg0 = sig_icc_bus_s0_msg0,
		.status0 = sig_icc_bus_s0_status0,
		.msg1 = sig_icc_bus_s0_msg1,
		.status1 = sig_icc_bus_s0_status1,
	};
	static const struct sig_icc_bus_funcs s1_funcs = {
		.eoi = sig_icc_bus_s1_eoi,
		.msg0 = sig_icc_bus_s1_msg0,
		.status0 = sig_icc_bus_s1_status0,
		.msg1 = sig_icc_bus_s1_msg1,
		.status1 = sig_icc_bus_s1_status1,
	};
	struct sig_icc_bus_merge *m;

	m = malloc(sizeof(*m));
	assert(m);

	m->s0 = s0;
	sig_icc_bus_connect(s0, m, &s0_funcs);
	m->s1 = s1;
	sig_icc_bus_connect(s1, m, &s1_funcs);

	return m;
}

void
sig_icc_bus_split(struct sig_icc_bus_merge *m)
{
	fixme();
}

struct sig_icc_bus *
sig_icc_bus_create(const char *name)
{
	struct sig_icc_bus *bus;

	bus = malloc(sizeof(*bus));
	assert(bus);

	bus->type = SIG_GEN_ICC_BUS;
	bus->nmembers = 0;

	return bus;
}

void
sig_icc_bus_destroy(struct sig_icc_bus *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_ICC_BUS);

	free(sig);
}
