/*
 * rtp.c - Source for RTP Plugin core
 *
 * Farsight RTP/AVP/SAVP/AVPF Module
 * Copyright (C) 2005,2006 Collabora Ltd.
 * Copyright (C) 2005,2006 Nokia Corporation
 *   @author Rob Taylor <rob.taylor@collabora.co.uk>
 *   @author Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 * Copyright (C) 2005 INdT 
 *   @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "farsight-plugin.h"

#include "rtp.h"
#include "rtpsession.h"
#include "rtpstream.h"
#include "rtpgstcodecs.h"

static gboolean 
init_plugin (FarsightPlugin *plugin)
{
  farsight_rtp_session_register_type (G_TYPE_MODULE(plugin));
  farsight_rtp_stream_register_type(G_TYPE_MODULE(plugin));

  return TRUE;
}

static void
unload_plugin (FarsightPlugin *plugin)
{
  guint i = 0;
  /* make sure all list of codecs are unloaded */
  for (; i < FARSIGHT_MEDIA_TYPE_LAST; ++i)
    unload_codecs ((FarsightMediaType) i);
}

static FarsightPluginInfo plugin_info = {
  FARSIGHT_MAJOR_VERSION,
  FARSIGHT_MINOR_VERSION,

  "Farsight RTP plugin",                              /* description */
  "0.1.0",                                            /* version */
  "Farsight Project",                                 /* author */
  "http://farsight.sf.net/",                          /* homepage */
  unload_plugin,                                      /* unload */
  farsight_rtp_session_new,                           /* new */
};

FARSIGHT_INIT_PLUGIN (init_plugin, plugin_info)
