#include <falcon/message_defs.h>
#include "error.h"

#ifndef FALCON_DECLARE_MODULE
# define HPDF_MODSTR(hpdf_def) \
  FAL_MODSTR(hpdf_error_id_##hpdf_def, #hpdf_def)
#else
# define HPDF_MODSTR(hpdf_def) \
    FAL_MODSTR(hpdf_error_id_##hpdf_def, #hpdf_def) \
    Falcon::Mod::hpdf::storeVMStringID(hpdf_def, hpdf_error_id_##hpdf_def);
#endif

FAL_MODSTR(hpdf_unknow_error, "unknown error");

HPDF_MODSTR(HPDF_ARRAY_COUNT_ERR);
HPDF_MODSTR(HPDF_ARRAY_ITEM_NOT_FOUND);
HPDF_MODSTR(HPDF_ARRAY_ITEM_UNEXPECTED_TYPE);
HPDF_MODSTR(HPDF_BINARY_LENGTH_ERR);
HPDF_MODSTR(HPDF_CANNOT_GET_PALLET);
HPDF_MODSTR(HPDF_DICT_COUNT_ERR);
HPDF_MODSTR(HPDF_DICT_ITEM_NOT_FOUND);
HPDF_MODSTR(HPDF_DICT_ITEM_UNEXPECTED_TYPE);
HPDF_MODSTR(HPDF_DICT_STREAM_LENGTH_NOT_FOUND);
HPDF_MODSTR(HPDF_DOC_ENCRYPTDICT_NOT_FOUND);
HPDF_MODSTR(HPDF_DOC_INVALID_OBJECT);

HPDF_MODSTR(HPDF_DUPLICATE_REGISTRATION);
HPDF_MODSTR(HPDF_EXCEED_JWW_CODE_NUM_LIMIT);

HPDF_MODSTR(HPDF_ENCRYPT_INVALID_PASSWORD);

HPDF_MODSTR(HPDF_ERR_UNKNOWN_CLASS);
HPDF_MODSTR(HPDF_EXCEED_GSTATE_LIMIT);
HPDF_MODSTR(HPDF_FAILD_TO_ALLOC_MEM);
HPDF_MODSTR(HPDF_FILE_IO_ERROR);
HPDF_MODSTR(HPDF_FILE_OPEN_ERROR);

HPDF_MODSTR(HPDF_FONT_EXISTS);
HPDF_MODSTR(HPDF_FONT_INVALID_WIDTHS_TABLE);
HPDF_MODSTR(HPDF_INVALID_AFM_HEADER);
HPDF_MODSTR(HPDF_INVALID_ANNOTATION);

HPDF_MODSTR(HPDF_INVALID_BIT_PER_COMPONENT);
HPDF_MODSTR(HPDF_INVALID_CHAR_MATRICS_DATA);
HPDF_MODSTR(HPDF_INVALID_COLOR_SPACE);
HPDF_MODSTR(HPDF_INVALID_COMPRESSION_MODE);
HPDF_MODSTR(HPDF_INVALID_DATE_TIME);
HPDF_MODSTR(HPDF_INVALID_DESTINATION);

HPDF_MODSTR(HPDF_INVALID_DOCUMENT);
HPDF_MODSTR(HPDF_INVALID_DOCUMENT_STATE);
HPDF_MODSTR(HPDF_INVALID_ENCODER);
HPDF_MODSTR(HPDF_INVALID_ENCODER_TYPE);

HPDF_MODSTR(HPDF_INVALID_ENCODING_NAME);
HPDF_MODSTR(HPDF_INVALID_ENCRYPT_KEY_LEN);
HPDF_MODSTR(HPDF_INVALID_FONTDEF_DATA);
HPDF_MODSTR(HPDF_INVALID_FONTDEF_TYPE);
HPDF_MODSTR(HPDF_INVALID_FONT_NAME);
HPDF_MODSTR(HPDF_INVALID_IMAGE);
HPDF_MODSTR(HPDF_INVALID_JPEG_DATA);
HPDF_MODSTR(HPDF_INVALID_N_DATA);
HPDF_MODSTR(HPDF_INVALID_OBJECT);
HPDF_MODSTR(HPDF_INVALID_OBJ_ID);
HPDF_MODSTR(HPDF_INVALID_OPERATION);
HPDF_MODSTR(HPDF_INVALID_OUTLINE);
HPDF_MODSTR(HPDF_INVALID_PAGE);
HPDF_MODSTR(HPDF_INVALID_PAGES);
HPDF_MODSTR(HPDF_INVALID_PARAMETER);

HPDF_MODSTR(HPDF_INVALID_PNG_IMAGE);
HPDF_MODSTR(HPDF_INVALID_STREAM);
HPDF_MODSTR(HPDF_MISSING_FILE_NAME_ENTRY);

HPDF_MODSTR(HPDF_INVALID_TTC_FILE);
HPDF_MODSTR(HPDF_INVALID_TTC_INDEX);
HPDF_MODSTR(HPDF_INVALID_WX_DATA);
HPDF_MODSTR(HPDF_ITEM_NOT_FOUND);
HPDF_MODSTR(HPDF_LIBPNG_ERROR);
HPDF_MODSTR(HPDF_NAME_INVALID_VALUE);
HPDF_MODSTR(HPDF_NAME_OUT_OF_RANGE);

HPDF_MODSTR(HPDF_PAGE_INVALID_PARAM_COUNT);
HPDF_MODSTR(HPDF_PAGES_MISSING_KIDS_ENTRY);
HPDF_MODSTR(HPDF_PAGE_CANNOT_FIND_OBJECT);
HPDF_MODSTR(HPDF_PAGE_CANNOT_GET_ROOT_PAGES);
HPDF_MODSTR(HPDF_PAGE_CANNOT_RESTORE_GSTATE);
HPDF_MODSTR(HPDF_PAGE_CANNOT_SET_PARENT);
HPDF_MODSTR(HPDF_PAGE_FONT_NOT_FOUND);
HPDF_MODSTR(HPDF_PAGE_INVALID_FONT);
HPDF_MODSTR(HPDF_PAGE_INVALID_FONT_SIZE);
HPDF_MODSTR(HPDF_PAGE_INVALID_GMODE);
HPDF_MODSTR(HPDF_PAGE_INVALID_INDEX);
HPDF_MODSTR(HPDF_PAGE_INVALID_ROTATE_VALUE);
HPDF_MODSTR(HPDF_PAGE_INVALID_SIZE);
HPDF_MODSTR(HPDF_PAGE_INVALID_XOBJECT);
HPDF_MODSTR(HPDF_PAGE_OUT_OF_RANGE);
HPDF_MODSTR(HPDF_REAL_OUT_OF_RANGE);
HPDF_MODSTR(HPDF_STREAM_EOF);
HPDF_MODSTR(HPDF_STREAM_READLN_CONTINUE);

HPDF_MODSTR(HPDF_STRING_OUT_OF_RANGE);
HPDF_MODSTR(HPDF_THIS_FUNC_WAS_SKIPPED);
HPDF_MODSTR(HPDF_TTF_CANNOT_EMBEDDING_FONT);
HPDF_MODSTR(HPDF_TTF_INVALID_CMAP);
HPDF_MODSTR(HPDF_TTF_INVALID_FOMAT);
HPDF_MODSTR(HPDF_TTF_MISSING_TABLE);
HPDF_MODSTR(HPDF_UNSUPPORTED_FONT_TYPE);
HPDF_MODSTR(HPDF_UNSUPPORTED_FUNC);
HPDF_MODSTR(HPDF_UNSUPPORTED_JPEG_FORMAT);
HPDF_MODSTR(HPDF_UNSUPPORTED_TYPE1_FONT);
HPDF_MODSTR(HPDF_XREF_COUNT_ERR);
HPDF_MODSTR(HPDF_ZLIB_ERROR);
HPDF_MODSTR(HPDF_INVALID_PAGE_INDEX);
HPDF_MODSTR(HPDF_INVALID_URI);
HPDF_MODSTR(HPDF_PAGE_LAYOUT_OUT_OF_RANGE);
HPDF_MODSTR(HPDF_PAGE_MODE_OUT_OF_RANGE);
HPDF_MODSTR(HPDF_PAGE_NUM_STYLE_OUT_OF_RANGE);
HPDF_MODSTR(HPDF_ANNOT_INVALID_ICON);
HPDF_MODSTR(HPDF_ANNOT_INVALID_BORDER_STYLE);
HPDF_MODSTR(HPDF_PAGE_INVALID_DIRECTION);
HPDF_MODSTR(HPDF_INVALID_FONT);
HPDF_MODSTR(HPDF_PAGE_INSUFFICIENT_SPACE);
HPDF_MODSTR(HPDF_PAGE_INVALID_DISPLAY_TIME);
HPDF_MODSTR(HPDF_PAGE_INVALID_TRANSITION_TIME);
HPDF_MODSTR(HPDF_INVALID_PAGE_SLIDESHOW_TYPE);
HPDF_MODSTR(HPDF_EXT_GSTATE_OUT_OF_RANGE);
HPDF_MODSTR(HPDF_INVALID_EXT_GSTATE);
HPDF_MODSTR(HPDF_EXT_GSTATE_READ_ONLY);
HPDF_MODSTR(HPDF_INVALID_U3D_DATA);

#undef HPDF_MODSTR
