/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright © CNRS, INRIA, Université Bordeaux 1
 * See COPYING in top-level directory.
 */

#define _GNU_SOURCE 1
#define _REENTRANT

#include <unistd.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <dlfcn.h>
#include <string.h>

#include "mpi.h"
#include "mpi_eztrace.h"
#include "mpi_ev_codes.h"
#include "eztrace.h"

static int MPI_Ibsend_core (void* buf, int count, MPI_Datatype datatype, int dest, int tag,
			    MPI_Comm comm, MPI_Request *req)
{
  return libMPI_Ibsend(buf, count, datatype, dest, tag, comm, req);
}

static void MPI_Ibsend_epilog (void* buf, int count, MPI_Datatype datatype, int dest, int tag,
			       MPI_Comm comm, MPI_Fint *req)
{
  int size;
  MPI_Type_size(datatype, &size);
  EZTRACE_EVENT4 (FUT_MPI_IBSEND, count*size, dest, tag, req);
}

int MPI_Ibsend (void* buf, int count, MPI_Datatype datatype, int dest, int tag, MPI_Comm comm, MPI_Request *req)
{
  FUNCTION_ENTRY;
  int ret = MPI_Ibsend_core(buf, count, datatype, dest, tag, comm, req);
  MPI_Ibsend_epilog(buf, count, datatype, dest, tag, comm, req);
  return ret;
}


void mpif_ibsend_ (void *buf, int *count, MPI_Fint *d, int *dest,
		   int *tag, MPI_Fint *c, MPI_Fint *r, int *error)
{
  MPI_Comm c_comm = MPI_Comm_f2c(*c);
  MPI_Datatype c_type = MPI_Type_f2c(*d);
  MPI_Request c_req = MPI_Request_f2c(*r);
  *error = MPI_Ibsend_core(buf, *count, c_type, *dest, *tag, c_comm, &c_req);
  *r= MPI_Request_c2f(c_req);
  MPI_Ibsend_epilog(buf, *count, c_type, *dest, *tag, c_comm, r);
}
