/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@susqu.edu                 * 
*************************************************************/

/********************************************************************
*
*  File: express.h
*
*  Contents: defines for expression parsing and evaluation.
*/

/* node types, numbered above 512 to avoid yacc token numbers */
#define INIT_VERTEX_EDGE_  513
#define INIT_VERTEX_FACET_  514
#define INIT_VERTEX_BODY_ 515
#define INIT_EDGE_VERTEX_ 516
#define INIT_EDGE_FACET_  517
#define INIT_EDGE_BODY_ 518
#define INIT_FACET_VERTEX_  519
#define INIT_FACET_EDGE_  520
#define INIT_FACET_BODY_ 521
#define INIT_BODY_VERTEX_  522
#define INIT_BODY_EDGE_  523
#define INIT_BODY_FACET_ 524
#define NEXT_VERTEX_EDGE_  525
#define NEXT_VERTEX_FACET_  526
#define NEXT_VERTEX_BODY_ 527
#define NEXT_EDGE_VERTEX_  528
#define NEXT_EDGE_FACET_  529
#define NEXT_EDGE_BODY_ 530
#define NEXT_FACET_VERTEX_  531
#define NEXT_FACET_EDGE_  532
#define NEXT_FACET_BODY_ 533
#define NEXT_BODY_VERTEX_  534
#define NEXT_BODY_EDGE_  535
#define NEXT_BODY_FACET_ 536
#define NEXT_VERTEX_  537
#define NEXT_EDGE_  538
#define NEXT_FACET_  539
#define NEXT_BODY_  540
#define NEXT_ELEMENT_  541
#define INIT_VERTEX_  542
#define INIT_EDGE_  543
#define INIT_FACET_  544
#define INIT_BODY_  545
#define INIT_ELEMENT_  546
#define SET_GRAVITY_      547
#define SET_DIFFUSION_      548
#define SET_GLOBAL_      549
#define SET_COLOR_      550
#define SET_DENSITY_      551
#define SET_PRESSURE_      552
#define SET_VOLUME_      553
#define SET_CONSTRAINT_      554
#define SET_TAG_      555
#define SET_OPACITY_      556
#define SET_SCALE_      557
#define SET_COORD_    558
#define SET_COORD_1      559
#define SET_COORD_2      560
#define SET_COORD_3      561
#define SET_COORD_4      562
#define SET_COORD_5      563
#define SET_COORD_6      564
#define SET_COORD_7      565
#define SET_COORD_8      566
#define SET_PROCEDURE_      567
#define SET_PROC_END_      568
#define SET_QUANTITY_      569
#define SET_AUTOCHOP_      570
#define SET_GAP_CONSTANT_      571
#define SET_AMBIENT_PRESSURE_      572
#define SET_FIXED_AREA_      573
#define SET_COLORMAP_      574
#define SET_THICKEN_      575
#define SET_BACKGROUND_      576
#define SET_OPTIMIZE_      577
#define SET_FIXED_ 578
#define GET_FIXED_ 579
#define GET_LENGTH_ 580
#define GET_VALENCE_ 581
#define GET_AREA_ 582
#define GET_VOLUME_ 583
#define GET_DENSITY_ 584
#define GET_ID_ 585
#define GET_TAG_ 586
#define GET_ORIGINAL_ 587
#define INIT_AVG_ 588
#define INIT_SUM_ 589
#define INIT_MAX_ 590
#define INIT_MIN_ 591
#define INIT_COUNT_ 592
#define AGGREGATE_INIT_ 593
#define AGGREGATE_END_ 594
#define AGGREGATE_ 595
#define SET_INIT_ 596
#define UNSET_CONSTRAINT_ 597
#define UNSET_BOUNDARY_ 598
#define GET_COLOR_ 599
#define GET_SQ_MEAN_CURV_ 600
#define GET_INTERNAL_ 601
#define V_VERTEXCOUNT 602
#define V_EDGECOUNT 603
#define V_FACETCOUNT 604
#define V_BODYCOUNT 605
#define V_FACETEDGECOUNT 606
#define V_ENERGY 607
#define V_AREA 608
#define V_LENGTH 609
#define V_SCALE 610
#define LIST_PROCS_ 611
#define PRINTFHEAD_ 612
#define PREPRINTF_  613
#define EXPRLIST_  614
#define SPRINTFHEAD_ 615
#define SET_SGLOBAL_      616
#define GET_OID_ 617
#define GET_FRONTCOLOR_ 618
#define GET_BACKCOLOR_  619
#define SET_FRONTCOLOR_ 620
#define SET_BACKCOLOR_  621
#define SET_PARAM_      622
#define SET_PARAM_1      623
#define SET_PARAM_2      624
#define SET_PARAM_3      625
#define SET_PARAM_4      626
#define SET_PARAM_5      627
#define SET_PARAM_6      628
#define SET_PARAM_7      629
#define SET_ATTRIBUTE_    630
#define SET_PHASE_    631
#define GET_PHASE_    632
#define LEXERROR      633
#define PRESPRINTF_      634
#define V_SURFACE_DIMENSION 635
#define V_SPACE_DIMENSION 636
#define TOGGLEVALUE      637
#define V_TORUS         638
#define V_TORUS_FILLED    639
#define V_SYMMETRY_GROUP 640
#define V_SIMPLEX      641
#define V_INTEGRAL_ORDER 642
#define GET_STAR_        643
#define GET_PRESSURE_      644
#define SET_INTERNAL_      645
#define V_TOLERANCE     646
#define AUTODISPLAY_    647
#define V_EQUI_COUNT    648
#define V_DELETE_COUNT    650
#define V_REFINE_COUNT    651
#define V_NOTCH_COUNT    652
#define V_DISSOLVE_COUNT    653
#define V_POP_COUNT    654
#define V_WHERE_COUNT    655
#define PUSH_NAMED_QUANTITY 656
#define SET_NAMED_QUANTITY_ 657
#define GET_USERATTR_ 658
#define GET_QUANTITY_ 659
#define UNSET_NAMED_QUANTITY_ 660
#define GET_WRAP_ 661
#define FINISHED    701
#define PUSHCONST  702
#define PUSHPARAM  703
#define PUSHPI      704
#define PUSHE    705
#define PLUS     706
#define MINUS    707
#define TIMES    708
#define DIVIDE      709
#define INTPOW     710
#define POW     711
#define SIN     712
#define COS     713
#define TAN     714
#define SQRT    715
#define LOG     716
#define EXP     717
#define COPY    718
#define ACOS    719
#define ASIN    720
#define ATAN    721
#define CHS     722
#define INV     723
#define SQR     724
#define PUSHG      725
#define EQUATE     726
#define PUSHADJUSTABLE 727
#define ABS     728
#define USERFUNC  729
#define EXEC_      729
#define REPEAT_    730
#define FULLEXPR  731
#define SINH  732
#define COSH  733
#define REPLACECONST 734
#define REALMOD     735
#define CEIL_     736
#define FLOOR_     737
#define ATAN2_     738
#define NOP_    739
#define V_HESS_EPSILON     740
#define HESSIAN_DIFF_ 741
#define SHOW_INNER_    742
#define SHOW_OUTER_    743
#define CLIPPED_CELLS_ 744
#define RAW_CELLS_    745
#define CONNECTED_CELLS_ 746
#define NORMAL_MOTION_  747
#define RUNGE_KUTTA_  748
#define DETURCK_    749
#define KUSNER_    750
#define VIEW_4D_    751
#define CONF_EDGE_SQCURV_ 752
#define SQGAUSS_  753
#define AUTOPOP_ 754
#define OLD_AREA_ 755
#define APPROX_CURV_ 756
#define CHECK_INCREASE_ 757
#define DEBUG_ 758
#define MEMDEBUG_ 759
#define EFFECTIVE_AREA_ 760
#define ESTIMATE_  761
#define POST_PROJECT_ 762
#define TRANSFORMS_ 763
#define QUIET_ 764
#define CONJ_GRAD_ 765
#define HOMOTHETY_ 766
#define FACET_COLORS_ 767
#define SHADING_  768
#define DIV_NORMAL_CURVATURE_ 769
#define NORMAL_CURVATURE_ 770
#define BOUNDARY_CURVATURE_ 771
#define SELF_SIMILAR_ 772
#define GV_BINARY_ 773
#define METRIC_CONVERSION_ 774
#define AUTORECALC_ 775
#define PINNING_ 776
#define FORCE_POS_DEF_ 777
#define V_SCALE_SCALE 778
#define GET_EXTRA_ATTR_ 779
#define SET_EXTRA_ATTR_ 780
#define SET_ATTRIBUTE_LOOP_  781
#define SET_ATTRIBUTE_L    782
#define TANH    783
#define ATANH    784
#define ASINH    785
#define ACOSH    786
#define V_ITER_COUNTER 787
#define QUIETGO_ 788
#define GET_MIDV_ 789
#define RIBIERE_CG_ 790
#define ASSUME_ORIENTED_ 791
#define HESSIAN_QUIET_ 792
#define CONJUNCTION_END 793
#define JIGGLE_TOGGLE_ 794
#define V_TIME 795
#define V_JIG_TEMP 796
#define SYMBOL_ELEMENT_ 797
#define SINGLE_ELEMENT_ 798
#define INDEXED_SUBTYPE_ 799
#define INDEXED_ATTRIBUTE 800
#define QUALIFIED_ATTRIBUTE 801
#define STRPRINT_ 802
#define GET_TRIPLE_PT_ 804
#define SET_TRIPLE_PT_ 805
#define GET_TETRA_PT_ 806
#define SET_TETRA_PT_ 807
#define UNSET_TETRA_PT_ 808
#define UNSET_TRIPLE_PT_ 809
#define PUSHQPRESSURE_ 810
#define PUSHQTARGET_ 811
#define PUSHQVALUE_ 812
#define PUSHQMODULUS_ 813
#define SET_QMODULUS_ 814
#define SET_QTARGET_ 815
#define YSMP_      816
#define BUNCH_KAUFFMAN_ 817
#define V_EIGENPOS 818
#define V_EIGENNEG 819
#define V_EIGENZERO 820
#define QUANTITIES_ONLY_ 821
#define EVERYTHING_QUANTITIES_ 822
#define METRIC_CONVERT_ 823
#define GET_TARGET_ 824
#define MAXIMUM_ 825
#define UNSET_FACET_BODY_ 826
#define SET_ORIENTATION_ 827
#define V_PICKVNUM 828
#define V_PICKENUM 829
#define V_PICKFNUM 830
#define LINEAR_METRIC_ 831
#define V_LINEAR_METRIC_MIX 832
#define INVOKE_P_MENU_ 833
#define GEOMVIEW_TOGGLE_ 834
#define DO_TOP_ 835
#define DO_END_ 836
#define DO_ENTRY_ 837
#define SET_MODEL_ 838
#define V_RANDOM_SEED 839
#define MINIMUM_ 840
#define V_INTEGRAL_ORDER_1D 841
#define V_INTEGRAL_ORDER_2D 842
#define GET_ORIENTATION_ 843
#define SET_TARGET_ 844
#define UNSET_FIXED_  845
#define UNSET_DENSITY_  846 
#define UNSET_VOLUME_    847
#define UNSET_PRESSURE_  848
#define UNSET_TARGET_  849
#define GET_VOLCONST_  850
#define SET_VOLCONST_  851
#define GET_TORUS_PERIODS_  852
#define PUSHQVOLCONST_  853
#define GET_FIXEDVOL_  854
#define SET_QVOLCONST_  855
#define SET_QPARAMETER_1_  856
#define PUSHQPARAMETER_1_  857
#define SINGLE_ELEMENT_INIT_  858
#define REDEFINE_SINGLE_  859
#define UNREDEFINE_SINGLE_  860
#define V_QUADRATIC_METRIC_MIX 861
#define GEOMPIPE_TOGGLE_ 862
#define V_LAST_EIGENVALUE 863
#define V_LAST_HESSIAN_SCALE 864
#define SQUARED_GRADIENT_ 865
#define PRINT_LETTER_ 866
#define REDIRECT_END_ 867
#define PIPE_END_ 868
#define V_LAGRANGE_ORDER 869
#define SET_AXIAL_POINT_ 870
#define UNSET_AXIAL_POINT_ 871
#define GET_AXIAL_POINT_ 872
#define H_INVERSE_METRIC_ 873
#define HELP_KEYWORD 874
#define SKINNY_ 875
#define TORDUP_ 876
#define V_GAP_CONSTANT 877
#define V_THICKNESS 878
#define V_TARGET_TOLERANCE 879
#define V_CLOCK 880
#define FIX_QUANTITY_ 881
#define UNFIX_QUANTITY_ 882
#define SET_ORIGINAL_ 883
#define V_SCALE_LIMIT 884
#define SET_MMODULUS_ 885
#define GET_INSTANCE_ 886
#define PUSHMMODULUS_ 887
#define PUSHMVALUE_    888
#define PSCOLORFLAG_  889
#define GRIDFLAG_      890
#define CROSSINGFLAG_ 891
#define LABELFLAG_     892
#define SHOW_ALL_QUANTITIES_ 893
#define GET_INVERSE_PERIODS_  894
#define CREATE_EDGE_  895
#define SET_NO_REFINE_ 896
#define UNSET_NO_REFINE_ 897
#define GET_NO_REFINE_ 898
#define CREATE_VERTEX_  899
#define CREATE_FACET_  900
#define CREATE_BODY_  901
#define SET_FRONTBODY_ 902
#define SET_BACKBODY_ 903
#define V_TRANSFORM_COUNT 904
#define GT_        905
#define LT_        906
#define GET_BACKBODY_  907
#define GET_FRONTBODY_ 908
#define GET_TRANSFORM_EXPR_ 909
#define LOGFILE_TOGGLE_ 910
#define SET_WRAP_ 911
#define PLUSASSIGN_ 912
#define SUBASSIGN_ 913
#define MULTASSIGN_ 914
#define DIVASSIGN_ 915
#define NULLBLOCK_ 916
#define SINGLE_ASSIGN_ 917
#define SET_ATTRIBUTE_A 918
#define SET_METHOD_INSTANCE_ 919
#define UNSET_METHOD_INSTANCE_ 920
#define PUSH_METHOD_INSTANCE_ 921
#define LIST_ATTRIBUTES_ 922
#define NULLCMD_ 923
#define FIX_PARAMETER_ 924
#define UNFIX_PARAMETER_ 925
#define ITDEBUG_ 926
#define ZENER_DRAG_ 927
#define VOLGRADS_EVERY_ 928
#define V_RANDOM 929
#define PUSHQTOLERANCE_ 930
#define SET_QTOLERANCE_ 931
#define PUSHDELTA_  932
#define SET_DELTA_  933
#define BACKCULL_  934
#define V_BRIGHTNESS 935
#define V_DIFFUSION 936
#define DEFINE_IDENT_ 937
#define V_BACKGROUND 938
#define SET_NO_DISPLAY_ 939
#define UNSET_NO_DISPLAY_ 940
#define GET_NO_DISPLAY_ 941
#define V_MEMARENA 942
#define V_MEMUSED 943
#define INDEXED_COORD_ 944
#define V_LAST_ERROR 945
#define VERBOSE_ 946
#define ACOMMANDEXPR_ 947
#define CMDLIST_ 948
#define ULONG_TYPE_ 949
#define INDEXED_ELEMENT_ 950
#define MEAN_CURV_ 951
#define REPEAT_INIT_ 952
#define SYMATTR_ 953
#define INIT_SUBELEMENT_ 954
#define GET_DIHEDRAL_ 955
#define INIT_FACETEDGE_ 956
#define GET_EDGE_ 957
#define GET_FACET_ 958
#define NEXT_FACETEDGE_ 959
#define PUSHGLOBAL_ 960
#define COMMAND_BLOCK_ 961
#define IFTEST_ 962
#define WHILE_TOP_ 963
#define WHILE_END_ 964
#define PRINT_PROCEDURE_ 965
#define SHOW_END_ 966
#define AMBIENT_PRESSURE_ 967
#define TOGGLE_QUANTITY_ 968
#define INTERP_NORMALS_ 969
#define MEAN_CURV_INT_ 970
#define COND_TEST_ 971
#define COND_EXPR_ 972
#define COND_ELSE_ 973
#define BACKGROUND_ 974
#define V_AMBIENT_PRESSURE 975
#define V_HESSIAN_SLANT_CUTOFF 976
#define WRAP_COMPOSE_ 977
#define WRAP_INVERSE_ 978
#define GET_VERTEXNORMAL_ 979
#define SET_VIEW_MATRIX_ 980
#define VIEW_MATRIX_LVALUE_ 981
#define ACTUAL_VOLUME_ 982
#define SELF_ELEMENT_  983
#define UNSET_FRONTBODY_ 984
#define UNSET_BACKBODY_ 985

/* for BREAK and CONTINUE */
extern int loopdepth;

/* tree node for expression trees */
struct treenode 
            { int left;    /* left subexpression index offset  */
              int right;   /* right subexpression index offset */
              int type;    /* type of node                     */
              int flags;
              union { int intval;            /* misc. integer data */
                      REAL  real;            /* constant value     */
                      struct sym *symptr;    /* symbol table ptrs  */
                      char *string;          /* string value       */
                      element_id id;         /* element ids        */
                      struct expnode enode;  /* for expression     */
                      dll_func_type funcptr; /* DLL function       */
                    } op1;    /* operand 1*/
              union { int intval;            /* misc. integer data */
                      struct sym *symptr;    /* symbol table ptrs  */
                      char *string;
                      element_id id;         /* element ids        */
                    } op2;    /* operand  2 */
              struct { int intval[2]; /* misc. integer data */
                       struct sym *symptr;   /* symbol table ptrs  */
                       char *string;
                       element_id id;        /* element ids        */
                     } op3;
              int stackpos; /* for chopping stack after break or continue */
            };
/* flags */
#define LOCAL_VAR_REF 4
#define LOCAL_VAR_REF_2 8
#define LOCAL_VAR_REF_3 0x10
#define HAS_STRING    0x20

/* for some bit packing */
#define ESHIFT 12
