/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: common.h
 *
 */

/*
 * Global functions exported by common.c
 */

/* External APIs provided by common.c */

extern int evms_can_delete(object_handle_t thing);

extern int evms_can_destroy(object_handle_t thing);

extern int evms_can_replace(object_handle_t source,
			    object_handle_t target);

extern int evms_can_set_info(engine_handle_t thing_handle);

extern int evms_delete(object_handle_t thing);

extern int evms_destroy(object_handle_t thing);

extern int evms_replace(object_handle_t  source,
			object_handle_t  target);

extern int evms_get_handle_object_type(object_handle_t handle,
                                       object_type_t * type);

extern int evms_get_info(object_handle_t          thing,
                         handle_object_info_t * * info);

extern int evms_get_extended_info(object_handle_t           thing,
                                  char                    * descriptor_name,
                                  extended_info_array_t * * info);

extern int evms_set_info(engine_handle_t  thing_handle,
                         option_array_t * options);

extern int evms_get_feature_list(object_handle_t    object,
                                 handle_array_t * * plugins);

extern int evms_get_object_handle_for_name(object_type_t   type,
                                           char          * name,
                                           object_handle_t * object_handle);

/* Internal functions to share with other Engine source modules */

void free_extended_info_array_contents(void * object);

extern boolean is_top_object(storage_object_t * object);

extern void update_all_stop_data_states(void);

extern int remove_feature_headers(storage_object_t * obj);

extern int set_feature_header_dirty(storage_object_t * obj);

extern storage_object_t * get_working_top_object(storage_object_t * obj);

extern void sync_volumes(void);

extern int make_list(handle_array_t * ha,
                     list_anchor_t    list);

extern void free_info_object_contents(void * object);

extern int make_handle_array(list_anchor_t      list,
			     handle_array_t * * ha);

