/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * 	Module: general_test.c
 */


#include <ece.h>
#include <plugin.h>
#include <glib.h>
#include <getopt.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include "eceinternal.h"


#define SEND_INTERVAL 1
#define MAX_NODE_LENGTH 256

extern char *optarg;
extern int optind, opterr, optopt;

/***************************global variable****************************/

extern plugin_record_t ece_plugin_record;
int slave;
ece_event_t *mdata=NULL;
int messageSize=0;
cluster_functions_t * ece_funcs;
char mynode_str[MAX_NODE_LENGTH];


/*************************internal static  functions**********************/
/*
static void 
createMessage(ece_msg_t* ecemsg,const char* dest_str){
  ece_funcs->string_to_nodeid(dest_str,&ecemsg->node);
  if(messageSize ==0){
    char* msg;

    msg=malloc(strlen("hello world!"));
    ecemsg->size = strlen("hello world!");    
    memcpy(msg, "hello world!", ecemsg->size);
    ecemsg->msg=msg;
  }
  else{
    char* msg;
    int i=0;
    int bytesRemaining=messageSize;
    char* messagePtr;
    
    msg= (char*)malloc(messageSize);
    messagePtr=msg;
    
    while(bytesRemaining >0 ){
      int bytesWritten = snprintf(messagePtr,
				  bytesRemaining,
				  "test string %d.  ", 
				  i++);
      
      if(bytesWritten <=0)
	break;
      messagePtr +=bytesWritten;
      bytesRemaining -= bytesWritten;
    }
    ecemsg->size=messageSize;
    ecemsg->msg=msg;
  }
}

*/

/*************************call back functions ****************************/


static void mycb(const ece_callback_class_t class, 
		 const size_t size, 
		 const void *data){
  
  ece_event_t *memdata = (ece_event_t *)data;
  ece_msg_t *msg = (ece_msg_t *)data;
  char *str;
  int i;
  
  switch(class) {
  case CALLBACK_MEMBERSHIP:
    fprintf(stderr, "called mycb type=%d num_entries=%d\n", 
	    memdata->type, memdata->num_entries);
    
    for (i=0; i< memdata->num_entries; i++) {
      fprintf(stderr, "%s\n", memdata->node[i].bytes);
    }
    fprintf(stderr, "-------------------\n");
    break;
  case CALLBACK_MESSAGE:
    str = (char *)g_strndup((char *)msg->msg,msg->size);
    fprintf(stderr, "mycb message msg->node=%s, msg->core=%d,"
	    "cmd=%d, size=%d data=%s\n",
	    (char *)(msg->node.bytes),
	    msg->corrolator,
	    msg->cmd,
	    msg->size,
	    (char *)str);
    free(str);
    break;
  }
  
  
  return;
  
  
  
}

static void mycb1(const ece_callback_class_t class, 
		  const size_t size, 
		  const void *data){
  
  ece_event_t *memdata = (ece_event_t *)data;
  ece_msg_t *msg = (ece_msg_t *)data;
  char *str;
  int i;
  
  
  switch(class) {
  case CALLBACK_MEMBERSHIP:
    fprintf(stderr, "called mycb1 type=%d num_entries=%d\n", 
	    memdata->type, memdata->num_entries);
    
    for (i=0; i< memdata->num_entries; i++) {
      fprintf(stderr, "%s\n", memdata->node[i].bytes);
    }
    fprintf(stderr, "-------------------\n");
    mdata= malloc(size);
    memcpy(mdata, memdata, size);
    break;
  case CALLBACK_MESSAGE:
    str = (char *)g_strndup((char *)msg->msg, msg->size);
    fprintf(stderr, "mycb1 message msg->node=%s, msg->core=%d,"
	    "cmd=%d, size=%d data=%s\n",
	    (char *)(msg->node.bytes),
	    msg->corrolator,
	    msg->cmd,
	    msg->size,
	    (char *)str);
    free(str);
    break;
  }
  
  return;
}

ece_mode_t evms_engine_mode(){
  
  if(slave) return SLAVE;
  return ENGINE_DAEMON;
}

engine_functions_t engine_functions = {
  get_engine_plugin_api_version: NULL,
  get_plugin_list:               NULL,
  get_plugin_by_ID:              NULL,
  get_plugin_by_name:            NULL,
  get_volume_list:               NULL,
  get_object_list:               NULL,
  get_container_list:            NULL,
  allocate_logical_disk:         NULL,
  free_logical_disk:             NULL,
  allocate_segment:              NULL,
  free_segment:                  NULL,
  allocate_container:            NULL,
  free_container:                NULL,
  allocate_region:               NULL,
  free_region:                   NULL,
  allocate_evms_object:          NULL,
  free_evms_object:              NULL,
  open_object:                   NULL,
  read_object:                   NULL,
  write_object:                  NULL,
  ioctl_object:                  NULL,
  close_object:                  NULL,
  engine_alloc:                  malloc,
  engine_free:                   NULL,
  commit_in_progress:            NULL,
  write_log_entry:               NULL,
  calculate_CRC:                 NULL,
  calculate_checksum:            NULL,
  add_sectors_to_kill_list:      NULL,
  validate_name:                 NULL,
  register_name:                 NULL,
  unregister_name:               NULL,
  can_expand_by:                 NULL,
  can_shrink_by:                 NULL,
  user_message:                  NULL,
  user_communication:            NULL,
  progress:                      NULL,
  can_rename:                    NULL,
  is_mounted:                    NULL,
  assign_fsim_to_volume:         NULL,
  unassign_fsim_from_volume:     NULL,
  get_engine_mode:               evms_engine_mode,
  dm_allocate_target:            NULL,
  dm_add_target:                 NULL,
  dm_deallocate_targets:         NULL,
  dm_activate:                   NULL,
  dm_deactivate:                 NULL,
  dm_rename:                     NULL,
  dm_update_status:              NULL,
  dm_get_targets:                NULL,
  get_config_bool:               NULL,
  get_config_uint32:             NULL,
  get_config_uint32_array:       NULL,
  get_config_uint64:             NULL,
  get_config_uint64_array:       NULL,
  get_config_string:             NULL,
  get_config_string_array:       NULL,
  get_clusterid:                 NULL,
  get_nodeid:                    NULL,
  nodeid_to_string:              NULL,
  string_to_nodeid:              NULL
};

#define OPTARGS "s"

int main(int argc, char **argv) {

  ece_nodeid_t mynode;
  ece_clusterid_t clusterid;
  int retVal;
  int  option_index = 0;
  static struct option long_options[] = /* Long command line options */
    {
      {"help",0,0,'h'},
      {"mode",1,0,'m'},
      {"msgsize", 1, 0,'s'},
      {"mynode_str", 1, 0,'d'},      
      {0 , 0 , 0 , 0}
    };
  boolean mynode_str_input=FALSE;

  /***************************command line processing *******************/
  while ((retVal = getopt_long(argc,
			       argv,
			       "m:hs:d:",
                               long_options, &option_index)) != -1)
    {
      switch (retVal){
      case 'm':
	if(strcasecmp("slave",optarg)==0)
	  slave=1;
	else if (strcasecmp("master",optarg) ==0)
	  slave=0;
	else{
	  fprintf(stderr, "unknown mode\n");
	  fflush(stderr);
	  exit(1);
	}
	break;
      case 's':
	messageSize = strtoul(optarg, NULL,10);	  
	if(messageSize <=0){
	  fprintf(stderr,"invalid message size:%d\n", messageSize);
	  exit(1);
	}
	break;
      case 'd':
        strcpy(mynode_str, optarg);
	mynode_str_input=TRUE;
	break;
      case 'h':
	fprintf (stderr, "Usage: %s: [Optional Arguments]
[Optional Arguments]
-m --mode     master or slave mode (default master)
-s --msgsize  size of sending-out message size 
             (default the size of \"hello, world!\")
-h --help     print this help message
",argv[0]);
	fflush(stderr);
	exit(1);
      }  
      
    }
  
  if(! mynode_str_input){    
    fprintf(stderr, "please specify my node string using -d option\n");
    exit(1);
  }
    fprintf(stderr,"mode = %s, message_size = ", slave?"slave":"master");
    if(messageSize == 0)
      fprintf(stderr,"default value");
    else
      fprintf(stderr, "%d",messageSize);
    fprintf(stderr,"\n");
    
  /**************************command line processing done***************/

  
  ece_funcs=ece_plugin_record.functions.cluster;
  
  
  //initialize  
  if(ece_funcs->setup_evms_plugin(&engine_functions) == ENODEV){
    fprintf(stderr, "no ece service availbale\n");
    return 1;
  }

  sleep(1);

  printf("setup_evms_plugin done\n");
  
  {
    printf("\n******************Testing get_my_nodeid() and get_clusterid()***************:\n");
    
    ece_funcs->get_my_nodeid(&mynode);
    ece_funcs->get_clusterid(&clusterid);
    printf("clusterid=%s, my_nodeid=%s\n",(char*)&clusterid,(char*)&mynode);
    printf("\n");
  }

  {
    ece_nodeid_t nodeid;
    ece_funcs->string_to_nodeid(mynode_str,&nodeid);
    
    printf("******************Testing string_to_nodeid()***************:\n");
    printf("comparing mynode get_my_nodeid() %s \nwith nodeid string_to_nodeid() %s----", (char*)&mynode,(char*)&nodeid);
    if(memcmp(&mynode,&nodeid,sizeof(ece_nodeid_t)) == 0)
      printf("same\n");
    else
      printf("different\n");
    printf("\n");
  }


  {
    char temp[256];
    int length=256;
    ece_funcs->nodeid_to_string(&mynode,temp,&length );

    printf("***************Testing nodeid_to_string()****************\n");
    printf("comparing nodeid_to_string() %s with \nmynode_str %s----", temp, mynode_str);
    if(strcmp(temp,mynode_str) == 0)
    printf("same\n");
    else
      printf("different\n");
    printf("\n");

  }


  {
    int num;
    ece_nodeid_t* nodes;
    int i;
    int length;
    char str[256];

    printf("***************Testing get_num_config_nodes() and get_all_nodes()****************\n");
    
    ece_funcs->get_num_config_nodes(&num);
    nodes = g_malloc(num*sizeof(ece_nodeid_t));
    ece_funcs->get_all_nodes(&num, nodes);
    length = 256;
    printf("num =%d , nodes are displayed belowed\n",num);
    for ( i = 0; i < num ; i++ ) {
      ece_funcs->nodeid_to_string(nodes+i, str, &length);
      fprintf(stderr, "nodes[%d]=%s\n", i, str);
    }
    printf("\n");
    
  }  


  {
    int num;
    ece_event_t *ev;
    int sz;
    sleep(1);
    printf("***************Testing get_membership()****************\n");
    ece_funcs->get_num_config_nodes(&num);
    sz = sizeof(ece_event_t)+num*sizeof(ece_nodeid_t);
    ev = malloc(sz);
    ev->num_entries = num;
    fprintf(stderr, "membership is \n");
    if(ece_funcs->get_membership(ev) != ENOSPC)
      mycb1(CALLBACK_MEMBERSHIP, sz, ev);
    printf("\n");
  }
  

  {
    int rc;
    int i;
    extended_info_array_t* info_array;

    printf("***************Testing get_plugin_info()****************\n");
    
    rc=ece_funcs->get_plugin_info(NULL, &info_array);
    for(i=0;i < info_array->count; i++){
      printf("info %d:\n",i);
      printf("\t name=%s\n", info_array->info[i].name);
      printf("\t title=%s\n", info_array->info[i].title);
      printf("\t desc=%s\n", info_array->info[i].desc);
      printf("\t type=%d\n", info_array->info[i].type);
      printf("\t value.s=%s\n", info_array->info[i].value.s);
    }
    printf("\n");
  }
  
  
  //register call back functions

  ece_funcs->register_callback(DELTAS,mycb);
  ece_funcs->register_callback(FULL_MEMBERSHIP,mycb1);
  


  //unregister call back function
  ece_funcs->unregister_callback(mycb1);
  ece_funcs->unregister_callback(mycb);
  //clean up
  ece_funcs->cleanup_evms_plugin();
  return 0;
}

