/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 */

/*
 * Global data exported by internalAPI.c
 */

extern engine_functions_t engine_functions;

/*
 * Global functions exported by internalAPI.c
 */

extern int engine_get_plugin_list(plugin_type_t         type,
                                  plugin_search_flags_t flags,
                                  dlist_t             * plugin_list);

extern int engine_get_plugin_by_ID(plugin_id_t         pluginID,
                                   plugin_record_t * * plugin);

extern int engine_get_plugin_by_name(char              * plugin_short_name,
                                     plugin_record_t * * plugin);

extern int engine_get_volume_list(plugin_record_t * fsim,
                                  dlist_t         * volume_list);

extern int engine_get_object_list(object_type_t         object_type,
                                  data_type_t           data_type,
                                  plugin_record_t     * plugin,
                                  object_search_flags_t flags,
                                  dlist_t             * objects);

extern int engine_get_container_list(plugin_record_t * region_manger,
                                     dlist_t         * volume_list);

extern int engine_free_logical_disk(storage_object_t * disk);

extern int engine_free_segment(storage_object_t * segment);

extern int engine_free_region(storage_object_t * region);

extern int engine_free_evms_object(storage_object_t * object);

extern int engine_free_container(storage_container_t * container);

extern int engine_rediscover_volume(logical_volume_t * volume,
                                    BOOLEAN            sync_fs);

extern int engine_validate_name(char * name);

extern int engine_register_name(char * name);

extern int engine_unregister_name(char * name);

extern void clear_name_registry(void);

extern int engine_can_rename(storage_object_t * object);

