/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <gtk/gtk.h>
#include <string.h>
#include "contact.h"
#include "service.h"
#include "status.h"
#include "dialog.h"
#include "add_contact_window.h"
#include "pixmaps/tb_edit.xpm"
#include "pixmaps/cancel.xpm"


static gint window_open = 0;
static struct contact * my_contact;
static GtkWidget * edit_contact_window;
static GtkWidget * nick;
static GtkWidget * service_list;
static GtkWidget * group_list;

static void destroy( GtkWidget *widget, gpointer data )
{
    window_open = 0;
}

static void ok_callback( GtkWidget * widget, gpointer data )
{
   	gint service_id = get_service_id(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(service_list)->entry)));
        /* Rename log if logging is enabled */
        rename_nick_log(my_contact->nick, gtk_entry_get_text(GTK_ENTRY(nick)));
        strncpy(my_contact->nick, gtk_entry_get_text(GTK_ENTRY(nick)), 254);
        my_contact->nick[254] = '\0';
	my_contact->default_chatb = service_id;
	my_contact->default_filetransb = service_id;
	
	if (my_contact->label)
		gtk_label_set_text(GTK_LABEL(my_contact->label), my_contact->nick);
	move_contact(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(group_list)->entry)),
			my_contact);
	//refresh_contact_list();
	MakeEditContactList();
	write_contact_list();
	gtk_widget_destroy(edit_contact_window);
}

void edit_contact_window_new( struct contact * c )
{
	gchar buff[1024];
	if( !window_open )
	{
		GtkWidget * vbox = gtk_vbox_new( FALSE, 5 );
		GtkWidget * hbox = gtk_hbox_new( FALSE, 5 );
		GtkWidget * hbox2;
		GtkWidget * button;
		GtkWidget * label;
		GtkWidget * iconwid;
		GdkPixmap *icon;
      GdkBitmap *mask;
		GList * list;
		edit_contact_window = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_widget_realize(edit_contact_window);
		
		label = gtk_label_new("Contact Name:");
		gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
		gtk_widget_show(label);
		
		nick = gtk_entry_new();
		gtk_box_pack_start(GTK_BOX(hbox), nick, TRUE, TRUE, 5);
		gtk_entry_set_text(GTK_ENTRY(nick), c->nick );
		gtk_widget_show(nick);
		
		label = gtk_label_new("Default Protocol:");
		gtk_box_pack_start(GTK_BOX(hbox),label, FALSE, FALSE, 5);
		gtk_widget_show(label);
		
		service_list = gtk_combo_new();
		list = get_service_list();
		gtk_combo_set_popdown_strings(GTK_COMBO(service_list), list );
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(service_list)->entry), 
				eb_services[c->default_chatb].name);
		g_list_free(list);
		gtk_box_pack_start(GTK_BOX(hbox), service_list, TRUE, TRUE, 5 );
		gtk_widget_show(service_list);
		
		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);
		gtk_widget_show(hbox);

		hbox = gtk_hbox_new( FALSE, 5 );

		label = gtk_label_new("Group Name:");
		gtk_box_pack_start(GTK_BOX(hbox),label, FALSE, FALSE, 5);
		gtk_widget_show(label);
		
		group_list = gtk_combo_new();
		list = get_groups();
		gtk_combo_set_popdown_strings(GTK_COMBO(group_list), list );
		g_list_free(list);
		gtk_box_pack_start(GTK_BOX(hbox), group_list, TRUE, TRUE, 5 );
		gtk_widget_show(group_list);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(group_list)->entry), 
				c->group->name);
		hbox2 = gtk_hbox_new(TRUE, 5);
		gtk_widget_set_usize(hbox2, 200,25 );
		gtk_box_pack_start(GTK_BOX(hbox), hbox2, TRUE, TRUE, 5 );
		gtk_widget_show(hbox2);
		

		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);
		gtk_widget_show(hbox);

		hbox = gtk_hbox_new(FALSE, 5);
		hbox2 = gtk_hbox_new(TRUE, 5);
		gtk_widget_set_usize(hbox2, 200,25 );
		
		/*Ok Button*/
   
   	icon = gdk_pixmap_create_from_xpm_d( edit_contact_window->window, &mask, NULL, tb_edit_xpm);
   	iconwid = gtk_pixmap_new( icon, mask );
   	label = gtk_label_new("Apply");
   
   	gtk_box_pack_start(GTK_BOX(hbox), iconwid, FALSE, FALSE, 2);
   	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
   
   	gtk_widget_show(iconwid);
   	gtk_widget_show(label);
   
   	button = gtk_button_new();
   
   	gtk_signal_connect(GTK_OBJECT(button), "clicked", 
					   GTK_SIGNAL_FUNC(ok_callback), NULL );
   	gtk_widget_show(hbox);
   
   	gtk_container_add (GTK_CONTAINER (button), hbox);
   
   	gtk_box_pack_start(GTK_BOX(hbox2), button, TRUE, TRUE, 5);
   	gtk_widget_show(button);
		
		/*Cancel Button*/
      
      hbox = gtk_hbox_new(FALSE, 5);
      icon = gdk_pixmap_create_from_xpm_d( edit_contact_window->window, &mask, NULL, cancel_xpm);
      iconwid = gtk_pixmap_new( icon, mask );
      label = gtk_label_new("Cancel");
      
      gtk_box_pack_start(GTK_BOX(hbox), iconwid, FALSE, FALSE, 2);
      gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
      
      gtk_widget_show(iconwid);
      gtk_widget_show(label);
      
      button = gtk_button_new();
      
      gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
								  GTK_SIGNAL_FUNC(gtk_widget_destroy),
								  GTK_OBJECT(edit_contact_window));
      gtk_widget_show(hbox);     
      
      gtk_container_add (GTK_CONTAINER (button), hbox);		
      
      gtk_box_pack_start(GTK_BOX(hbox2), button, TRUE, TRUE, 5);
      gtk_widget_show(button);
		
		/*Buttons End*/
		
		hbox = gtk_hbox_new(FALSE, 5);
		
		gtk_box_pack_end(GTK_BOX(hbox), hbox2, FALSE, FALSE, 5 );
		gtk_widget_show(hbox2);
		
		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);
		gtk_widget_show(hbox);
		
		gtk_container_add(GTK_CONTAINER(edit_contact_window), vbox);
		gtk_widget_show(vbox);
		
		gtk_signal_connect( GTK_OBJECT(edit_contact_window), "destroy",
						GTK_SIGNAL_FUNC(destroy), NULL );
		gtk_widget_show(edit_contact_window);
	}
	
	gtk_entry_set_text(GTK_ENTRY(nick), c->nick );
	//gtk_combo_set_value_in_list(GTK_COMBO(service_list), c-> default_chatb, 0 );
	g_snprintf(buff,1024,"Edit Properties for %s", c->nick);
	gtk_window_set_title(GTK_WINDOW(edit_contact_window), buff ); 
	eb_icon(edit_contact_window->window);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(service_list)->entry),
					   eb_services[c->default_chatb].name );

	gtk_signal_connect( GTK_OBJECT(edit_contact_window), "destroy",
						GTK_SIGNAL_FUNC(destroy), NULL );
	my_contact = c;
	window_open = 1;
}
			
