/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <glib.h>
#include <gtk/gtk.h>
#include "input_list.h"
#include "plugin_api.h"
#include "dialog.h"

char notes_dir[NAME_MAX];
char notes_editor[MAX_PREF_LEN]="xedit";

/*************************************************************************************
 *                             Begin Module Code
 ************************************************************************************/
/*  Module defines */
#define plugin_info notes_LTX_plugin_info
#define plugin_init notes_LTX_plugin_init
#define plugin_finish notes_LTX_plugin_finish

/* Function Prototypes */
/* ebmCallbackData is a parent struct, the child of which will be an ebmContactData */
void notes_feature(ebmCallbackData *data);
int plugin_init();
int plugin_finish();

static int ref_count=0;

/*  Module Exports */
PLUGIN_INFO plugin_info = {
	PLUGIN_UTILITY, 
	"Keep notes on contacts", 
	"Keep notes about your contacts and buddies", 
	"$Revision: 1.2 $",
	"$Date: 2002/03/04 14:58:43 $",
	&ref_count,
	plugin_init,
	plugin_finish,
	NULL
};
/* End Module Exports */

static void *notes_tag=NULL;

int plugin_init()
{
	input_list * il = g_new0(input_list, 1);
	fprintf(stderr, "notes init\n");
	notes_tag=eb_add_menu_item("Notes", EB_CHAT_WINDOW_MENU, notes_feature, ebmCONTACTDATA, NULL);
	if(!notes_tag) {
		fprintf(stderr, "Error!  Unable to add Notes menu to chat window menu\n");
		return(-1);
	}
	g_snprintf(notes_dir, NAME_MAX, "%s/notes", eb_config_dir());
	mkdir(notes_dir, 0700);
	eb_debug(DBG_MOD, "Notes Dir: %s\n", notes_dir);
	plugin_info.prefs = il;
	il->widget.entry.value = notes_editor;
	il->widget.entry.name = "Notes Editor";
	il->type = EB_INPUT_ENTRY;
	return(0);
}

int plugin_finish()
{
	int result;

	result=eb_remove_menu_item(EB_CHAT_WINDOW_MENU, notes_tag);
	if(result) {
		g_warning("Unable to remove Notes menu item from chat window menu!");
		return(-1);
	}
	return(0);
}

/*************************************************************************************
 *                             End Module Code
 ************************************************************************************/

/* We're really going to get back an ebmContactData object */
void notes_feature(ebmCallbackData *data)
{
	ebmContactData *ecd=NULL;
	char buff[256];
	char cmd_buff[1024];

	eb_debug(DBG_MOD, ">\n");
	if(IS_ebmContactData(data))
		ecd=(ebmContactData *)data;
	else {	/* This should never happen, unless something is horribly wrong */
		fprintf(stderr, "*** Warning *** Unexpected ebmCallbackData type returned!\n");
		return;
	}
	eb_debug(DBG_MOD, "contact: %s remote_account: %s\n", ecd->contact, ecd->remote_account);
	sprintf(buff, "Notes on %s", ecd->contact);
	sprintf(cmd_buff, "%s %s/%s &", plugin_info.prefs->widget.entry.value, notes_dir, ecd->contact);
	system(cmd_buff);
}
