/* msn_core.c - this contains all the functions used to do anything with MSN */

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "md5.h"

#include "msn_core.h"
#include "msn_interface.h"
#include "msn_bittybits.h"

// Define all those extern'ed variables in msn_core.h:
llist * connections=NULL;

int next_trid=10;
char buf[1024]; // used for anything temporary

void msn_init(msnconn * conn, char * username, char * password)
{
  conn->auth=new authdata_NS;
  conn->type=CONN_NS;
  ((authdata_NS *)conn->auth)->username=msn_permstring(username);
  ((authdata_NS *)conn->auth)->password=msn_permstring(password);

  msn_add_to_llist(connections, conn);
}

void msn_invite_user(msnconn * conn, char * rcpt)
{
  sprintf(buf, "CAL %d %s\r\n", next_trid++, rcpt);
  write(conn->sock, buf, strlen(buf));
}

void msn_send_IM(msnconn * conn, char * rcpt, char * msg)
{
  static char header[]="MIME-Version: 1.0\r\nContent-Type: text/plain\r\n\r\n";

  if(conn->type==CONN_NS)
  {
    llist * list;

    list=connections;
    while(1)
    {
      msnconn * c;
      llist * users;

      if(list==NULL) { break ; }
      c=(msnconn *)list->data;
      if(c->type==CONN_NS) { list=list->next; continue; }
      users=c->users;
      // the below sends a message into this session if the only other participant is
      // the user we want to talk to
      if(users!=NULL && users->next==NULL && !strcmp(((char_data *)users->data)->c, rcpt))
      {
        msn_send_IM(c, rcpt, msg);
        return;
      }

      list=list->next;
    }
    // otherwise, just connect
    msn_request_SB(conn, rcpt, msg, NULL);
    return;
  }

  sprintf(buf, "MSG %d N %d\r\n%s", next_trid, strlen(msg)+strlen(header), header);
  write(conn->sock, buf, strlen(buf));
  write(conn->sock, msg, strlen(msg));
  next_trid++;
}

void msn_send_typing(msnconn * conn)
{
  char header[]="MIME-Version: 1.0\r\nContent-Type: text/x-msmsgscontrol\r\nTypingUser: ";
  char * username=((authdata_SB *)conn->auth)->username;

  sprintf(buf, "MSG %d U %d\r\n%s%s\r\n\r\n\r\n",
        next_trid++, strlen(header)+strlen(username)+6, header, username);

  write(conn->sock, buf, strlen(buf));
}

void msn_add_to_list(msnconn * conn, char * list, char * username)
{
  sprintf(buf, "ADD %d %s %s %s\r\n", next_trid++, list, username, username);
  write(conn->sock, buf, strlen(buf));
}

void msn_del_from_list(msnconn * conn, char * list, char * username)
{
  sprintf(buf, "REM %d %s %s\r\n", next_trid++, list, username);
  write(conn->sock, buf, strlen(buf));
}

void msn_set_GTC(msnconn * conn, char c)
{
  sprintf(buf, "GTC %d %c\r\n", next_trid++, c);
  write(conn->sock, buf, strlen(buf));
}

void msn_set_BLP(msnconn * conn, char c)
{
  sprintf(buf, "BLP %d %cL\r\n", next_trid++, c);
  write(conn->sock, buf, strlen(buf));
}

void msn_set_friendlyname(msnconn * conn, char * friendlyname)
{
  char * username;

  username=((authdata_NS *)conn->auth)->username;
  sprintf(buf, "REA %d %s %s\r\n", next_trid++, username, msn_encode_URL(friendlyname));
  write(conn->sock, buf, strlen(buf));
}

void msn_sync_lists(msnconn * conn, int version)
{
  syncinfo * info=new syncinfo;

  info->serial=version;

  sprintf(buf, "SYN %d %d\r\n", next_trid, version);
  write(conn->sock, buf, strlen(buf));

  msn_add_callback(conn, msn_syncdata, next_trid, info);

  next_trid++;
}

void msn_syncdata(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  syncinfo * info=(syncinfo *)data;

  if(!strcmp(args[0], "SYN"))
  {
    if(info->serial==atoi(args[2]))
    {
      delete info;
      info=NULL;
      msn_del_callback(conn, trid);
      ext_got_info(conn, NULL);
      return;
    } else {
      info->serial=atoi(args[2]);
      ext_latest_serial(conn, info->serial);
    }
  }

  if(!strcmp(args[0], "LST"))
  {
    if(!strcmp(args[2], "FL"))
    {
      if(!strcmp(args[5], "0"))
      {
        info->fl=NULL; info->complete|=LST_FL;
      } else {
        userdata * newuser=new userdata();
        newuser->username=msn_permstring(args[6]);
        newuser->friendlyname=msn_decode_URL(msn_permstring(args[6]));
        msn_add_to_llist(info->fl, newuser);
        if(atoi(args[4])==atoi(args[5]))
        { info->complete|=LST_FL; }
      }
    }
    if(!strcmp(args[2], "RL"))
    {
      if(!strcmp(args[5], "0"))
      {
        info->rl=NULL; info->complete|=LST_RL; // no mates! :-)
      } else {
        userdata * newuser=new userdata();
        newuser->username=msn_permstring(args[6]);
        newuser->friendlyname=msn_decode_URL(msn_permstring(args[6]));
        msn_add_to_llist(info->rl, newuser);
        if(atoi(args[4])==atoi(args[5]))
        { info->complete|=LST_RL; }
      }
    }
    if(!strcmp(args[2], "AL"))
    {
      if(!strcmp(args[5], "0"))
      {
        info->al=NULL; info->complete|=LST_AL;
      } else {
        userdata * newuser=new userdata();
        newuser->username=msn_permstring(args[6]);
        newuser->friendlyname=msn_decode_URL(msn_permstring(args[6]));
        msn_add_to_llist(info->al, newuser);
        if(atoi(args[4])==atoi(args[5]))
        { info->complete|=LST_AL; }
      }
    }
    if(!strcmp(args[2], "BL"))
    {
      if(!strcmp(args[5], "0"))
      {
        info->bl=NULL; info->complete|=LST_BL;
      } else {
        userdata * newuser=new userdata();
        newuser->username=msn_permstring(args[6]);
        newuser->friendlyname=msn_decode_URL(msn_permstring(args[6]));
        msn_add_to_llist(info->fl, newuser);
        if(atoi(args[4])==atoi(args[5]))
        { info->complete|=LST_BL; }
      }
    }
  }

  if(!strcmp(args[0], "GTC"))
  {
    info->gtc=args[3][0];
    info->complete|=COMPLETE_GTC;
    ext_got_GTC(conn, args[3][0]);
  }

  if(!strcmp(args[0], "BLP"))
  {
    info->blp=args[3][0];
    info->complete|=COMPLETE_BLP;
    ext_got_BLP(conn, args[3][0]);
  }

  if(info->complete == (LST_FL|LST_RL|LST_AL|LST_BL|COMPLETE_BLP|COMPLETE_GTC))
  {
    msn_del_callback(conn, trid);
    msn_check_rl(conn, info);
    ext_got_info(conn, info);
    delete info;
  }
}

void msn_check_rl(msnconn * conn, syncinfo * info)
{
  llist * flist; // FL
  llist * olist; // other list
  userdata * fcontact;
  userdata * ocontact;

  int is_on_list;

  flist=info->rl;

  while(flist!=NULL)
  {
    is_on_list=0;

    fcontact=(userdata *)flist->data;

    for(olist=info->al; olist!=info->bl; olist=info->bl)
    {
      while(olist!=NULL)
      {
        ocontact=(userdata *)olist->data;
        if(!strcmp(ocontact->username, fcontact->username))
        {
          is_on_list=1;
          break;
        }
        olist=olist->next;
      }
      if(is_on_list) { break; } // avoid a second loop if unnecessary
    }

    if(!is_on_list)
    {
      ext_new_rl_entry(conn, fcontact->username, fcontact->friendlyname);
    }

    flist=flist->next;
  }
}

void msn_new_SB(msnconn * nsconn, void * tag)
{
  msn_request_SB(nsconn, NULL, NULL, tag);
}

void msn_request_SB(msnconn * nsconn, char * rcpt, char * msg, void * tag)
{
  conninfo_SB * info=new conninfo_SB;

  info->auth=new authdata_SB;
  info->auth->username=msn_permstring(((authdata_NS *)nsconn->auth)->username);
  info->auth->rcpt=msn_permstring(rcpt);
  info->auth->msg=msn_permstring(msg);
  info->auth->tag=tag;

  sprintf(buf, "XFR %d SB\r\n", next_trid);
  write(nsconn->sock, buf, strlen(buf));

  msn_add_callback(nsconn, msn_SBconn_2, next_trid, info);
  next_trid++;
}

void msn_SBconn_2(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  conninfo_SB * info=(conninfo_SB *)data;

  msn_del_callback(conn, trid);

  if(strcmp(args[0], "XFR"))
  {
    msn_show_verbose_error(atoi(args[0]));
    delete info;
    return;
  }

  info->auth->cookie=msn_permstring(args[5]);
  info->auth->sessionID=NULL;

  msnconn * newconn=new msnconn;

  newconn->auth=info->auth;
  newconn->type=CONN_SB;
  newconn->ready=0;

  msn_add_to_llist(connections, newconn);

  int port=1863;
  char * c;

  if((c=strstr(args[3], ":"))!=NULL)
  {
    *c='\0';
    c++;
    port=atoi(c);
  }

  delete info;

  msn_connect(newconn, args[3], port);
}

void msn_SBconn_3(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  authdata_SB * auth=(authdata_SB *)conn->auth;

  msn_del_callback(conn, trid);

  if(strcmp(args[2], "OK"))
  {
    msn_show_verbose_error(atoi(args[0]));
    msn_clean_up(conn);
    return;
  }

  if(auth->rcpt==NULL) // they're requesting the SB session the proper way
  {
    ext_got_SB(conn, auth->tag);
  } else {
    sprintf(buf, "CAL %d %s\r\n", next_trid, auth->rcpt);
    write(conn->sock, buf, strlen(buf));

    delete auth->rcpt;
    auth->rcpt=NULL;

    next_trid++;
  }
  conn->ready=1;
  ext_new_connection(conn);
}

void msn_handle_incoming(int sock)
{
  // First, we find which msnconn this socket belongs to

  llist * list;
  msnconn * conn;
  callback * call;

  char ** args;
  int numargs;
  int trid;

  list=connections;

  if(list==NULL) { return; }

  while(1)
  {
    conn=(msnconn *)list->data;
    if(conn->sock==sock)
    { break; }
    list=list->next;
    if(list==NULL)
    { printf("Not for us\n"); return; } // not for us
  }

  // OK, it's for us. Parse it, then deliver it to the appropriate handler

  args=msn_read_line(sock, &numargs);

  if(args==NULL)
  { msn_clean_up(conn); return; }

  if(!strcmp(args[0], "XFR") && !strcmp(args[2], "NS"))
  {
    delete conn->callbacks; // delete the callback data
    conn->callbacks=NULL;

    ext_unregister_sock(conn->sock);
    close(conn->sock);

    char * c;
    int port=1863;

    if((c=strstr(args[3], ":"))!=NULL)
    {
      *c='\0';
      c++;
      port=atoi(c);
    }

    msn_connect(conn, args[3], port);
    return;
  }

  if(!strcmp(args[0], "RNG"))
  {
    msn_handle_RNG(conn, args, numargs);
    return;
  }

  trid=atoi(args[1]);

  list=conn->callbacks;

  if(list!=NULL && trid>0)
  {
    while(1)
    {
      call=(callback *)list->data;
      if(call->trid==trid)
      {
        (call->func)(conn, trid, args, numargs, call->data);
        delete args[0];
        delete args;
        return;
      }
      list=list->next;
      if(list==NULL) { break; } // defaults
    }
  }

  msn_handle_default(conn, args, numargs);

  delete args[0];
  delete args;
}

void msn_handle_close(int sock)
{
  // First, we find which msnconn this socket belongs to

  llist * list;
  msnconn * conn;

  list=connections;

  if(list==NULL) { return; }

  while(1)
  {
    conn=(msnconn *)list->data;
    if(conn->sock==sock)
    { break; }
    list=list->next;
    if(list==NULL)
    { printf("Not for us\n"); return; } // not for us
  }

  msn_clean_up(conn);
}

void msn_handle_default(msnconn * conn, char ** args, int numargs)
{

  //     Switchboard messages

  if(!strcmp(args[0], "MSG"))
  {
    msn_handle_MSG(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "NAK"))
  {
    msn_handle_NAK(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "JOI"))
  {
    msn_handle_JOI(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "BYE"))
  {
    msn_handle_BYE(conn, args, numargs);
    return;
  }

  //    Notification server messages

  if(!strcmp(args[0], "NLN") || !strcmp(args[0], "ILN") || !strcmp(args[0], "FLN"))
  {
    msn_handle_statechange(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "CHG"))
  {
    ext_changed_state(conn, args[2]);
    return;
  }

  if(!strcmp(args[0], "ADD"))
  {
    msn_handle_ADD(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "REM"))
  {
    msn_handle_REM(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "BLP"))
  {
    msn_handle_BLP(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "GTC"))
  {
    msn_handle_GTC(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "REA"))
  {
    msn_handle_REA(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "OUT"))
  {
    msn_handle_OUT(conn, args, numargs);
    return;
  }

  if(isdigit(args[0][0]))
  {
    msn_show_verbose_error(atoi(args[0]));
    if(conn->type==CONN_SB)
    {
      printf("As it is a Switchboard connection, terminating on error.\n");
      msn_clean_up(conn);
    }
    return;
  }

  printf("Don't know what to do with this one, ignoring it:\n"); // DEBUG
  for(int a=0; a<numargs; a++)
  {
    printf("%s ", args[a]);
  }
  printf("\n");
}

void msn_handle_MSG(msnconn * conn, char ** args, int numargs)
{
  int msglen;
  char * msg;
  char * mime;
  char * body;
  char * tmp;

  msglen=atoi(args[3]);

  msg=new char[msglen+1];
  read(conn->sock, msg, msglen);
  msg[msglen]='\0';

  mime=msg;
  body=strstr(msg, "\r\n\r\n");
  if(body!=NULL) { body[2]='\0'; /* finish the MIME string */ body+=4; }

    // the below is a kludge until I remember the header name for TypingUser
  if((strstr(mime, "TypingUser")!=NULL) || (strstr(mime, "TypeingUser")!=NULL))
  { // the second of the above two is a workaround for a spelling bug in the Jabber MSN transport
    ext_typing_user(conn, args[1], args[2]);
    return;
  }

  // otherwise, assume a text message
  ext_got_IM(conn, args[1], msn_decode_URL(args[2]), body);
}

char * msn_find_in_mime(char * mime, char * header)
{
  char * retval;
  int pos;

  retval=strstr(mime, header);
     // FIX ME - the above should look for either beginning of string or \r\n before header
  if(retval==NULL) { return NULL; }

  while(*retval!=':') { retval++; }
  retval++; // pass the colon
  while(*retval==' ') { retval++; } // position at start of value

  pos=0;
  while(retval[pos]!='\0')
  {
    if(retval[pos]=='\r')
    {
      char * tmp;
      retval[pos]='\0';
      tmp=msn_permstring(retval);
      retval[pos]='\r';
    }
    pos++;
  }
}

void msn_handle_NAK(msnconn * conn, char ** args, int numargs)
{
  ext_IM_failed(conn);
}

void msn_handle_JOI(msnconn * conn, char ** args, int numargs)
{
  authdata_SB * auth;

  auth=(authdata_SB *)conn->auth;

  if(!strcmp(args[1], auth->username)) { return; }

  msn_add_to_llist(conn->users, new char_data(msn_permstring(args[1])));
  ext_user_joined(conn, args[1], msn_decode_URL(args[2]), 0);

  if(auth->msg!=NULL)
  {
    msn_send_IM(conn, NULL, auth->msg);
    delete auth->msg;
    auth->msg=NULL;
  }
}

void msn_handle_RNG(msnconn * conn, char ** args, int numargs)
{
  msnconn * newSBconn=new msnconn;
  authdata_SB * auth=new authdata_SB;

  newSBconn->type=CONN_SB;
  newSBconn->auth=auth;

  auth->username=msn_permstring(((authdata_NS *)(conn->auth))->username);
  auth->sessionID=msn_permstring(args[1]);
  auth->cookie=msn_permstring(args[4]);

  msn_add_to_llist(connections, newSBconn);

  char * c;
  int port=1863;
  if((c=strstr(args[2], ":"))!=NULL)
  {
    *c='\0';
    c++;
    port=atoi(c);
  }

  msn_connect(newSBconn, args[2], port);
}

void msn_handle_BYE(msnconn * conn, char ** args, int numargs)
{
  llist * list;
  char_data * c;

  list=conn->users;
  c=(char_data *)list->data;

  ext_user_left(conn, args[1]);

  while(1)
  {
    if(!strcmp(c->c, args[1])) // if the departing user matches this item on the list
    {
      if(list->next!=NULL)
      { list->next->prev=list->prev; }
      if(list->prev!=NULL)
      { list->prev->next=list->next; }
      if(list->prev==NULL) { conn->users=NULL; }
      list->next=NULL;  // otherwise the delete will go through the entire llist!
      list->prev=NULL;
      delete list; // will delete the char_data for us too
      break;
    }
  }

  if(conn->users==NULL)
  {
    msn_clean_up(conn);
  }
}

void msn_handle_statechange(msnconn * conn, char ** args, int numargs)
{
  char * buddy;
  char * state;
  char * friendlyname;

  if(!strcmp(args[0], "ILN"))
  {
    friendlyname=args[4];
    buddy=args[3];
    state=args[2];
  } else if(!strcmp(args[0], "FLN")) {
    buddy=args[1];
    ext_buddy_offline(conn, buddy);
    return;
  } else {
    friendlyname=args[3];
    buddy=args[2];
    state=args[1];
  }

  ext_buddy_set(conn, buddy, msn_decode_URL(friendlyname), state);
}

void msn_handle_ADD(msnconn * conn, char ** args, int numargs)
{
  if(!strcmp(args[2], "RL"))
  {
    ext_new_rl_entry(conn, args[4], msn_decode_URL(args[5]));
  }

  ext_new_list_entry(conn, args[2], args[4]);
  ext_latest_serial(conn, atoi(args[3]));
}

void msn_handle_REM(msnconn * conn, char ** args, int numargs)
{
  ext_del_list_entry(conn, args[2], args[4]);
  ext_latest_serial(conn, atoi(args[3]));
}


void msn_handle_BLP(msnconn * conn, char ** args, int numargs)
{
  ext_got_BLP(conn, args[3][0]);
  ext_latest_serial(conn, atoi(args[3]));
}

void msn_handle_GTC(msnconn * conn, char ** args, int numargs)
{
  ext_got_GTC(conn, args[3][0]);
  ext_latest_serial(conn, atoi(args[3]));
}

void msn_handle_REA(msnconn * conn, char ** args, int numargs)
{
  ext_latest_serial(conn, atoi(args[2]));
  ext_got_friendlyname(conn, msn_decode_URL(args[4]));
}

void msn_handle_OUT(msnconn * conn, char ** args, int numargs)
{
  if(numargs!=1)
  {
    if(!strcmp(args[1], "OTH"))
    {
      ext_show_error("You have logged onto MSN twice at once. Your MSN session will now terminate.");
    }
    if(!strcmp(args[1], "SSD"))
    {
      ext_show_error("This MSN server is going down for maintenance. Your MSN session will now terminate.");
    }
  }
  msn_clean_up(conn);
}

void msn_connect(msnconn * conn, char * server, int port)
{
  conn->ready=0;

  if(conn->type==CONN_SB)
  {
    authdata_SB * auth=(authdata_SB *)conn->auth;

    if((conn->sock=ext_connect_socket(server, port))==-1)
    {
      ext_show_error("Could not connect to switchboard server");
      return;
    }

    ext_register_sock(conn->sock);

    if(auth->sessionID==NULL)
    {
      sprintf(buf, "USR %d %s %s\r\n", next_trid, auth->username, auth->cookie);
      write(conn->sock, buf, strlen(buf));

      msn_add_callback(conn, msn_SBconn_3, next_trid, NULL);
    } else {
      sprintf(buf, "ANS %d %s %s %s\r\n", next_trid, auth->username, auth->cookie, auth->sessionID);
      write(conn->sock, buf, strlen(buf));

      msn_add_callback(conn, msn_SB_ans, next_trid, NULL);
    }

    next_trid++;

    return;
  } // Otherwise, it's a Notification Server (NS)

  connectinfo * info;

  info=new connectinfo;

  // The following is necessary as username and password may be temp variables
  // that will no longer exist when the next function is called
  info->username=msn_permstring( ((authdata_NS *)conn->auth)->username);
  info->password=msn_permstring( ((authdata_NS *)conn->auth)->password);

  conn->ready=0;
  if((conn->sock=ext_connect_socket(server, port))==-1)
  {
    ext_show_error("Could not connect to MSN server");
    return;
  }

  ext_register_sock(conn->sock);

  printf("Connected\n"); // DEBUG

  sprintf(buf, "VER %d MSNP2\r\n", next_trid);
  write(conn->sock, buf, strlen(buf));
  msn_add_callback(conn, msn_connect_2, next_trid, (callback_data *)info);
  next_trid++;
}

// Further connection functions:

void msn_connect_2(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  connectinfo * info;

  info=(connectinfo *)data;
  msn_del_callback(conn, trid);

  if(strcmp(args[0], "VER") || strcmp(args[2], "MSNP2")) // if either *differs*...
  {
    ext_show_error("Protocol negotiation failed");
    delete info;
    ext_unregister_sock(conn->sock);
    close(conn->sock);
    conn->sock=-1;
    return;
  }

  sprintf(buf, "USR %d MD5 I %s\r\n", next_trid, info->username);
  write(conn->sock, buf, strlen(buf));

  msn_add_callback(conn, msn_connect_3, next_trid, data);
  next_trid++;
}

void msn_connect_3(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  connectinfo * info;

  md5_state_t state;
  md5_byte_t digest[16];
  int a;

  info=(connectinfo *)data;
  msn_del_callback(conn, trid);

  if(isdigit(args[0][0]))
  {
    msn_show_verbose_error(atoi(args[0]));
    msn_clean_up(conn);
    delete info;
    return;
  }

  // OK, the challenge just arrived as args[4]

  md5_init(&state);
  md5_append(&state, (md5_byte_t *)(args[4]), strlen(args[4]));
  md5_append(&state, (md5_byte_t *)(info->password), strlen(info->password));
  md5_finish(&state, digest);

  sprintf(buf, "USR %d MD5 S ", next_trid);
  write(conn->sock, buf, strlen(buf));

  for(a=0; a<16; a++)
  {
    sprintf(buf, "%02x", digest[a]);
    write(conn->sock, buf, 2);
  }

  write(conn->sock, "\r\n", 2);

  msn_add_callback(conn, msn_connect_4, next_trid, data);
  next_trid++;
}

void msn_connect_4(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  connectinfo * info;

  info=(connectinfo *)data;
  msn_del_callback(conn, trid);

  if(isdigit(args[0][0]))
  {
    msn_show_verbose_error(atoi(args[0]));
    delete info;
    msn_clean_up(conn);
    return;
  }

  ext_got_friendlyname(conn, msn_decode_URL(args[4]));

  delete info;

  next_trid++;

  conn->ready=1;
  ext_new_connection(conn);
}

void msn_SB_ans(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  if(!strcmp(args[0], "ANS") && !strcmp(args[2], "OK"))
  { return; }

  if(isdigit(args[0][0]))
  {
    msn_del_callback(conn, trid);
    msn_show_verbose_error(atoi(args[0]));
    msn_clean_up(conn);
    return;
  }

  if(!strcmp(args[0], "IRO"))
  {
    if(!strcmp(args[4], ((authdata_SB *)conn->auth)->username)) { return; }
    ext_user_joined(conn, args[4], msn_decode_URL(args[5]), 1);
    msn_add_to_llist(conn->users, new char_data(msn_permstring(args[4])));
    if(!strcmp(args[2], args[3]))
    {
      conn->ready=1;
      ext_new_connection(conn);
      msn_del_callback(conn, trid);
    }
  }
}

void msn_set_state(msnconn * conn, char * state)
{
  sprintf(buf, "CHG %d %s\r\n", next_trid, state);
  write(conn->sock, buf, strlen(buf));
  next_trid++;
}

/*
void msn_connect_3(msnconn * conn, char ** args, int numargs, callback_data * data)
{
  connectinfo * info;

  info=(connectinfo *)data;
  msn_del_callback(conn, trid);
  trid++;

  if(isdigit(args[0][0]))
  {
    msn_print_verbose_error(atoi(args[0]));
    delete info;
    return;
  }

  sprintf(buf, "INF %d\r\n", trid, info->username);
  write(conn.sock, buf, strlen(buf));

  msn_add_callback(conn, msn_connect_4, trid, data);
}
*/
