/* msn_bittybits.c - all the little string- and list-bashing functions */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

#include "msn_core.h"
#include "msn_interface.h"
#include "msn_bittybits.h"

char ** msn_read_line(int sock, int * numargs)
{
  // Right, this is quite a task. Step One is to read the thing in.
  char ** retval;
  char c;
  int pos=0, numspaces=0;

  while(1)
  {
    if(read(sock, &c, 1)<1)
    {
      printf("What the..?!\n"); //DEBUG
      return NULL;
    }
    if(c=='\r') { continue; }
    if(c=='\n') { numspaces++; buf[pos]='\0'; break; }
    if(c==' ') { numspaces++; }
    buf[pos]=c;
    pos++;
  }

  if(numspaces==0) { printf("What the..?\n"); return NULL; }

  retval=new char * [numspaces];
  retval[0]=new char[strlen(buf)+1];
  strcpy(retval[0], buf);
  *numargs=numspaces;

  // OK, take it as read (boom, boom!)
  // Now we cruise through the string, changing all spaces to null 0's and setting
  // a pointer at the beginning of each substring

  pos=0;
  numspaces=1; // pointer #0 is already set at the beginning
  while(1)
  {
    if(retval[0][pos]==' ')
    {
      retval[0][pos]='\0';
      retval[numspaces]=retval[0]+pos+1;
      numspaces++;
      pos++;
      continue;
    }
    if(retval[0][pos]=='\0') { break; }

    pos++;
  }

  return retval;
}

void msn_clean_up(msnconn * conn)
{
  llist * connlist;
  connlist=connections;

  ext_closing_connection(conn);

  while(1)
  {
    if(connlist==NULL) { return; }
    if(connlist->data==conn) { break; }
    connlist=connlist->next;
  }

  close(conn->sock);
  ext_unregister_sock(conn->sock);
  delete conn;

  if(connlist->next!=NULL)
  { connlist->next->prev=connlist->prev; }
  if(connlist->prev!=NULL)
  { connlist->prev->next=connlist->next; }
  connlist->prev=NULL; // no recursive destructors, please...
  connlist->next=NULL;
  connlist->data=NULL; // already deleted the conn object
  delete connlist;
}

void msn_add_callback(msnconn * conn, void (*func)(msnconn * conn, int trid, char ** args, int numargs, callback_data * data), int trid, callback_data * data)
{
  callback * call;

  call=new callback;
  call->trid=trid;
  call->data=data;
  call->func=func;

  msn_add_to_llist(conn->callbacks, call);
}

void msn_del_callback(msnconn * conn, int trid)
{
  llist * list;
  callback * call;

  list=conn->callbacks;

  if(list==NULL) { return; }

  do
  {
    call=(callback *)list->data;
    if(call->trid==trid)
    {
      if(list->next!=NULL)
      { list->next->prev=list->prev; }
      if(list->prev!=NULL)
      { list->prev->next=list->next; } else { conn->callbacks=NULL; }
      list->prev=NULL; // no recursive destructors
      list->next=NULL;
      delete list;
      break;
    }
    list=list->next;
  } while(list!=NULL);
}

void msn_add_to_llist(llist *& listp, llist_data * data)
{
  llist * tlist;
  llist * newlist;

  if(listp==NULL) { listp=new llist; listp->data=data; return; }

  tlist=listp;

  while(tlist->next!=NULL) { tlist=tlist->next; }

  newlist=new llist;
  newlist->prev=tlist;
  newlist->next=NULL;
  newlist->data=data;
  tlist->next=newlist;
}

int msn_count_llist(llist * list)
{
  llist * l=list;
  int retval=0;

  if(l->data==NULL) { return 0; }

  while(l->next!=NULL) { l=l->next; retval++; }

  return retval;
}

char * msn_permstring(char * s)
{
  char * retval;

  if(s==NULL) { return NULL; }

  retval=new char [strlen(s)+1];

  strcpy(retval, s);

  return retval;
}

char * msn_decode_URL(char * s)
{
  char * rpos; // read
  char * wpos; // write

  wpos=rpos=s;

  while(1)
  {
    if(*rpos=='\0') { *wpos='\0'; break; }

    if(*rpos=='%')
    {
      char buf[3];
      int c;
      rpos++;
      buf[0]=*rpos;
      rpos++;
      buf[1]=*rpos;
      rpos++;
      buf[2]='\0';
      sscanf(buf, "%x", &c);
      *wpos=c;
      wpos++;
      continue;
    }

    *wpos=*rpos;
    rpos++;
    wpos++;
  }
  return s;
}

char * msn_encode_URL(char * s)
{
  char * rptr;
  char * wptr;
  char * retval;

  wptr=retval=new char[strlen(s)*3];
  rptr=s;

  while(1)
  {
    if(*rptr=='\0')
    { *wptr='\0'; break; }
    if(!(isalpha(*rptr) || isdigit(*rptr)))
    {
      sprintf(wptr, "%%%2x", (int)(*rptr));

      rptr++;
      wptr+=3;
      continue;
    }

    *wptr=*rptr;
    wptr++;
    rptr++;
  }

  return retval;
}

void msn_show_verbose_error(int errcode)
{
  char buf[512];
  sprintf(buf, "Error code: %d", errcode);
  ext_show_error(buf);
}

