/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-config-types.h,v 1.9 2004/12/12 12:38:57 hoa Exp $
 */

#ifndef ETPAN_CONFIG_TYPES_H

#define ETPAN_CONFIG_TYPES_H

#include "etpan-cfg-account-types.h"
#include "etpan-cfg-storage-types.h"
#include "etpan-cfg-vfolder-types.h"
#include "etpan-cfg-mime-types.h"
#include "etpan-cfg-abook-types.h"
#include "etpan-cfg-smime-types.h"
#include "etpan-cfg-global-types.h"
#include "etpan-cfg-color-types.h"
#include "etpan-folder-discover-types.h"
#include "etpan-cfg-sender-types.h"
#include <limits.h>
#include <paths.h>

#define ETPAN_APP_DATA_PATH ".libetpan"
#define ETPAN_LOG_PATH ".libetpan/log"
#define ETPAN_TMP_PATH ".libetpan/tmp"
#define ETPAN_TMP_MIME_PATH ".libetpan/tmp/mime"
#define ETPAN_FLAGS_PATH ".libetpan/flags"
#define ETPAN_CACHE_PATH ".libetpan/cache"

#define ETPAN_DEFAULT_CONFIG_PATH ".libetpan/config"
#define ETPAN_DEFAULT_SMIME_PATH ".libetpan/config/smime"
#define ETPAN_DEFAULT_SMIME_CERT_PATH ".libetpan/config/smime/cert"
#define ETPAN_DEFAULT_SMIME_CA_PATH ".libetpan/config/smime/ca"
#define ETPAN_DEFAULT_SMIME_PRIVATE_KEYS_PATH \
  ".libetpan/config/smime/private"

#ifdef _PATH_MAILDIR
#define ETPAN_SYSTEM_MAIL_PATH _PATH_MAILDIR
#else
#define ETPAN_SYSTEM_MAIL_PATH "/var/mail"
#endif
  
struct etpan_app_config {
  char path[PATH_MAX];
  struct etpan_global_config * global_config;
  struct etpan_account_config * account_config;
  struct etpan_storage_config * storage_config;
  struct etpan_vfolder_config * vfolder_config;
  struct etpan_mime_config * mime_config;
  struct etpan_smime_config * smime_config;
  struct etpan_color_config * color_config;
  struct etpan_abook_config * abook_config;
  struct etpan_discovery_manager * discovery_config;
  struct etpan_sender_config * sender_config;
};

#endif
