using GLib;
using Ethos;
using Gtk;

namespace Basic {
	static void main (string[] args) {
		Gtk.init (ref args);
		var example = new Example ();
		example.run ();
	}

	public class Example: GLib.Object {
		Manager manager;
		Window window;
		Button button;

		construct {
			manager = new Manager ();
			manager.initialized += () => { stdout.printf ("Ethos was initialized\n"); };
			manager.plugin_loaded += (_, plugin_info) => { stdout.printf ("%s plugin was loaded\n", plugin_info.id); };
			manager.plugin_unloaded += (_, plugin_info) => { stdout.printf ("%s plugin was unloaded\n", plugin_info.id); };

			window = new Window (WindowType.TOPLEVEL);
			window.title = "Vala Example";
			window.show ();

			button = new Button.from_stock (STOCK_QUIT);
			button.clicked += () => { Gtk.main_quit (); };
			window.add (button);
			button.show ();
		}

		public void run () {
			manager.initialize ();

			foreach (var loader in manager.get_plugin_loaders ()) {
				var name = loader.get_name ();
				if (name == null)
					name = "default";
				debug ("Loaded loader %s", name);
			}

			Gtk.main ();
		}
	}
}
