/* ethos-ui-configurable.c
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#include <ethos/ethos-plugin.h>
#include "ethos-ui-configurable.h"

/**
 * SECTION:ethos-ui-configurable
 * @title: EthosUIConfigurable
 * @short_description: interface for plugins that provide a configuration ui
 *
 * The #EthosUIConfigurable interface provides a way for plugins to expose
 * that they provide a gtk widget that can be used to configure the plugin.
 *
 * If a plugin implements the interface, the #EthosUIManagerWidget will show
 * a "Configure Plugin" button that will display the configuration widget.
 */

GType
ethos_ui_configurable_get_type (void)
{
	static GType g_type = 0;
	if (G_UNLIKELY (!g_type)) {
		const GTypeInfo g_type_info = {
			sizeof (EthosUIConfigurableIface),
			NULL,
			NULL,
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		g_type = g_type_register_static (G_TYPE_INTERFACE,
		                                 "EthosUIConfigurable",
		                                 &g_type_info,
		                                 0);
		g_type_interface_add_prerequisite (g_type, ETHOS_TYPE_PLUGIN);
	}
	return g_type;
}

/**
 * ethos_ui_configurable_configure:
 * @configurable: An #EthosUIConfigurable
 * @parent: The #GtkWindow that generated the request.
 *
 * Requests that the plugin shows its configuration dialog.  If @parent is non %NULL, then the
 * configuration dialog is set be transient to @parent.
 */
void
ethos_ui_configurable_configure (EthosUIConfigurable *configurable,
                                 GtkWidget           *parent)
{
	ETHOS_UI_CONFIGURABLE_GET_INTERFACE (configurable)->configure (configurable, parent);
}
