/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef ESYS_LSMQUATERNIONPY_H
#define ESYS_LSMQUATERNIONPY_H

#include <boost/python.hpp>
#include "Foundation/Quaternion.h"

#include <sstream>

namespace esys
{
  namespace lsm
  {
    class Vec3Py;
    
    class QuaternionPy : public Quaternion
    {
    public:
      QuaternionPy();

      QuaternionPy(double q0, double q1, double q2, double q3);

      QuaternionPy(const Vec3Py &v);
      
      QuaternionPy(const QuaternionPy &q);

      QuaternionPy(const Quaternion &q);

      QuaternionPy(const boost::python::object &pyOb);

      int len() const;

      double getItem(int i) const;

      void setItem(int i, double val);

      double norm() const;

      Vec3Py asAngleAxis() const;

      boost::python::tuple asAngleAxisPair() const;

      std::string toString() const;

      boost::python::list toList() const;

      boost::python::tuple toTuple() const;

      int getIndex(int i) const;

      class PickleSuite : public boost::python::pickle_suite
      {
      public:
        static
        boost::python::tuple
        getinitargs(QuaternionPy const& q);
      };
    };

    void exportQuaternion();
  }
}

std::ostream &operator<<(std::ostream &oStream, const esys::lsm::QuaternionPy &vec);

#endif //ESYS_LSMQUATERNIONPY_H
