/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


namespace esys
{
  namespace lsm
  {
    namespace bpu
    {
      template <typename TmplExtractType>
      PythonIterIterator<TmplExtractType>::PythonIterIterator(
        boost::python::object &iteratable
      )
        : m_hasNext(true),
          m_next(),
          m_iter(iteratable.attr("__iter__")())
      {
        update();
      }

      template <typename TmplExtractType>
      bool PythonIterIterator<TmplExtractType>::hasNext() const
      {
        return m_hasNext;
      }

      template <typename TmplExtractType>
      TmplExtractType PythonIterIterator<TmplExtractType>::next()
      {
        boost::python::object next = m_next;
        update();
        return boost::python::extract<TmplExtractType>(next);
      }

      template <typename TmplExtractType>
      void PythonIterIterator<TmplExtractType>::update()
      {
        try
        {
          m_next = m_iter.attr("next")();
        }
        catch (boost::python::error_already_set &e)
        {
          if (!PyErr_ExceptionMatches(PyExc_StopIteration))
          {
            throw;
          }
          PyErr_Clear();
          m_hasNext = false;
        }
      }
    }
  }
}
