# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Application configuration page.
"""

from ConfigurationPageBase import ConfigurationPageBase
from Ui_ApplicationPage import Ui_ApplicationPage

import Preferences

class ApplicationPage(ConfigurationPageBase, Ui_ApplicationPage):
    """
    Class implementing the Application configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("ApplicationPage")
        
        # set initial values
        self.singleApplicationCheckBox.setChecked(\
            Preferences.getUI("SingleApplicationMode"))
        self.splashScreenCheckBox.setChecked(\
            Preferences.getUI("ShowSplash"))
        
        period = Preferences.getUI("PerformVersionCheck")
        if period == 0:
            self.noCheckRadioButton.setChecked(True)
        elif period == 1:
            self.alwaysCheckRadioButton.setChecked(True)
        elif period == 2:
            self.dailyCheckRadioButton.setChecked(True)
        elif period == 3:
            self.weeklyCheckRadioButton.setChecked(True)
        elif period == 4:
            self.monthlyCheckRadioButton.setChecked(True)
        self.proxyGroup.setChecked(\
            Preferences.getUI("UseProxy"))
        self.proxyHostEdit.setText(\
            Preferences.getUI("ProxyHost"))
        self.proxyUserEdit.setText(\
            Preferences.getUI("ProxyUser"))
        self.proxyPasswordEdit.setText(\
            Preferences.getUI("ProxyPassword"))
        self.proxyPortSpin.setValue(\
            Preferences.getUI("ProxyPort"))
        
    def save(self):
        """
        Public slot to save the Application configuration.
        """
        Preferences.setUI("SingleApplicationMode",
            int(self.singleApplicationCheckBox.isChecked()))
        Preferences.setUI("ShowSplash",
            int(self.splashScreenCheckBox.isChecked()))
        
        if self.noCheckRadioButton.isChecked():
            period = 0
        elif self.alwaysCheckRadioButton.isChecked():
            period = 1
        elif self.dailyCheckRadioButton.isChecked():
            period = 2
        elif self.weeklyCheckRadioButton.isChecked():
            period = 3
        elif self.monthlyCheckRadioButton.isChecked():
            period = 4
        Preferences.setUI("PerformVersionCheck", period)
        Preferences.setUI("UseProxy",
            int(self.proxyGroup.isChecked()))
        Preferences.setUI("ProxyHost",
            self.proxyHostEdit.text())
        Preferences.setUI("ProxyUser",
            self.proxyUserEdit.text())
        Preferences.setUI("ProxyPassword",
            self.proxyPasswordEdit.text())
        Preferences.setUI("ProxyPort",
            self.proxyPortSpin.value())
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = ApplicationPage()
    return page
