# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the CVS Options Dialog for a new project from the repository.
"""

import os

from qt import *

from KdeQt import KQFileDialog

from NewProjectForm import CvsNewProjectOptionsForm

class CvsNewProjectOptionsDialog(CvsNewProjectOptionsForm):
    """
    Class implementing the Options Dialog for a new project from the repository.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        CvsNewProjectOptionsForm.__init__(self, parent, None, 1)
        
        hd = QDir.convertSeparators(QDir.homeDirPath())
        hd = os.path.join(unicode(hd), 'cvsroot')
        self.vcsDirectoryEdit.setText(hd)
        
        self.cvsTagValidator = QRegExpValidator(QRegExp(r"[a-zA-Z][a-zA-Z0-9_-]*"), self)
        
        self.vcsTagEdit.setValidator(self.cvsTagValidator)
        
    def handleDirectory(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsDirectoryEdit.text(),
            self, None, self.trUtf8("Select Repository-Directory"), 1)
            
        if not directory.isNull():
            self.vcsDirectoryEdit.setText(QDir.convertSeparators(directory))
            
    def handleProjectDir(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsProjectDirEdit.text(),
            self, None, self.trUtf8("Select Project Directory"), 1)
            
        if not directory.isNull():
            self.vcsProjectDirEdit.setText(QDir.convertSeparators(directory))
            
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of a string (project directory) and a dictionary
            containing the data entered.
        """
        vcsdatadict = {
            "repository" : unicode(self.vcsDirectoryEdit.text()),
            "archive" : unicode(self.vcsArchiveEdit.text()),
            "tag" : unicode(self.vcsTagEdit.text()),
        }
        return (unicode(self.vcsProjectDirEdit.text()), vcsdatadict)
