# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to confirm deletion of multiple files.
"""

from qt import *

from DeleteFilesConfirmationForm import DeleteFilesConfirmationForm


class DeleteFilesConfirmationDialog(DeleteFilesConfirmationForm):
    """
    Class implementing a dialog to confirm deletion of multiple files.
    """
    def __init__(self, parent, caption, message, okLabel, cancelLabel, files):
        DeleteFilesConfirmationForm.__init__(self,parent, modal=1)
        
        self.setCaption(caption)
        self.message.setText(message)
        self.okButton.setText(okLabel)
        self.cancelButton.setText(cancelLabel)
        
        for f in files:
            self.filesBox.insertItem(f)
            
        dummy = self.trUtf8("Dummy")
