#!/usr/bin/env entity

<object>
  <window ondelete="entity:exit" title="Clock" width="125">
    <valign>
      <object onbuttonpress="context_menu" name="clock" dragable="true" expand="false"
       default-lang="javascript" tooltip="">
        <menu visible="false" name="context" label="Menu">
	  <menuitem label="Remove" onselect="entity:exit"/>
	</menu>
	<label name="time" text="00:00:00"/>
	<timer interval="30000" action="update_tooltip"/>
	<timer interval="100" action="update_clock"/>
	<javascript>
	    
	    function update_clock (timer_node)
	    {
		d = new Date ();
	        str = d.format ("%H:%M:%S");
		enode ("label.time").attrib["text"] = str; 
	    }
	    update_clock ();
    
	    function update_tooltip (node)
	    {
		d = new Date ();
		str = d.format ("%a %b %e %Y");
		enode ("object").attrib.tooltip = str;
	    }
	    update_tooltip ();

	    function context_menu (node, button, x, y)
	    {
		if (button == 3) {
		    enode ("menu.context").attrib.popup = "true";
		}
	    }

	</javascript>
      </object>
    </valign>
  </window>
</object>
