/*
 *	Purges the recycled object specified by the index number from
 *	the command line.
 *
 *	This will PERMANENTLY PURGE the recycled object from the recycle
 *	bin so please use this with caution!
 */

#include <stdlib.h>
#include <glib.h>
#include <endeavour2.h>

int main(int argc, char *argv[])
{
	edv_context_struct *ctx = EDVContextNew();
	EDVContextLoadConfigurationFile(ctx, NULL);

	if(argc >= 2)
	{
	    guint index = atoi(argv[1]);

	    /* Purge the recycled object specified by index.
	     *
	     * Note that notify is set to TRUE, which means that if
	     * Endeavour2 is running then it will be aware of this
	     * incident and update it's values to reflect the change.
	     *
	     * We skip the callback functions (last two arguments) by
	     * setting them both NULL. This means that we are not 
	     * interested in the progress of this operation.
	     */
	    if(EDVPurge(
		ctx, index, TRUE, NULL, NULL
	    ))
		g_print("#%i: %s.\n", index, EDVRecycleGetError(ctx));
	    else
		g_print("#%i: Purged.\n", index);
	}
	else
	{
	    g_print(
"Usage: %s <index>\n",
		argv[0]
	    );
	}

	EDVContextSync(ctx);
	EDVContextDelete(ctx);

	return(0);
}
