C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      SUBROUTINE XROTATE(RANGLE,X,Y,Z,RX,RY,RZ,INROW)
C---->
C**** XROTATE
C
C     Purpose
C     -------
C
C     Rotate an array of (x,y,z) values about the x-axis.
C
C
C     Interface
C     ---------
C
C     CALL XROTATE(RANGLE,X,Y,Z,RX,RY,RZ,INROW)
C
C     Input
C     -----
C
C     RANGLE  - The angle of rotation (degrees)
C     (X,Y,Z) - Arrays of input (x,y,z) values.
C     INROW   - Number of coordinate values.
C
C
C     Output
C     ------
C
C     (RX,RY,RZ) - Arrays of rotated (x,y,z) values.
C
C
C     Method
C     ------
C
C     X remains unchanged.
C
C
C     Externals
C     ---------
C
C     None.
C
C
C     Author
C     ------
C
C     J.D.Chambers     ECMWF
C
C----<
C
      IMPLICIT NONE
C
C     Subroutine arguments
C
      REAL RANGLE,X,Y,Z,RX,RY,RZ
      DIMENSION X(*),Y(*),Z(*),RX(*),RY(*),RZ(*)
      INTEGER INROW
C
C     Local variables
C
      REAL FACTOR, ANGLE, SINA, COSA
      DATA FACTOR/0.017453293/
      INTEGER LOOP
C
      ANGLE = RANGLE * FACTOR
      SINA  = SIN(ANGLE)
      COSA  = COS(ANGLE)
C
      DO LOOP = 1, INROW
        RX(LOOP) = X(LOOP)
        RY(LOOP) =  Y(LOOP)*COSA + Z(LOOP)*SINA
        RZ(LOOP) = -Y(LOOP)*SINA + Z(LOOP)*COSA
      ENDDO
C
      RETURN
      END
