#ifndef __SENDER_H__
#define __SENDER_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "ask.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/

extern ask_t *sender_ask;

/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void sender_init (void);
extern void sender_free_resources (void);
extern void sender_refresh (void);
extern void sender_redraw (void);

/*+
  Move message to outbox.  This function doesn't send a message yet.
  You should run smtp_flush_outbox to send all messages from outbox.
  +*/
/** send */
extern void sender_go (void);
extern void sender_open (char *file);
extern void sender_open_new_to (char *to);
/*+
  Create a new message.  You are asked for message recepients, and
  subject.  Then an editor is opened.  After closing editor, you
  are taken to the window, where you can send or abort the message.
  +*/
/** compose new message */
extern void sender_open_new (void);
/*+
  Reply to the selected message.  After closing editor, you are
  taken to the window, where you can send or abort the message.
  +*/
/** reply to the message */
extern void sender_open_reply (void);
/*+
  Reply to the selected message.  The message is addressed not
  only to the author of the message, but to other recepients
  as well.
  +*/
/** reply to all recepients */
extern void sender_open_reply_all (void);
/*+
  Forward the selected message.  You are asked for recepients
  of the message.
  +*/
/** forward the message */
extern void sender_open_fwd (void);
/*+
  You can edit a message in draft or outbox.  After closing
  editor, you are taken to the window, where you can send or
  abort the message.  Please note that the edited message
  is removed from the box.
  +*/
/** edit selected message */
extern void sender_open_edit (void);
/*+
  Cancel the message.  You will be asked if you wish to move
  it to drafts, so you can finish it, and send later.  Please
  don't save a message with attachments, as it may be unreadable
  when you try to edit it later.
  +*/
/** close this window */
extern void sender_close (void);
/** move to the previous position */
extern void sender_prev (void);
/** move on to the next position */
extern void sender_next (void);
/** move to the previous page */
extern void sender_prev_page (void);
/** move on to the next page */
extern void sender_next_page (void);
/** move to the first position */
extern void sender_first (void);
/** move to the last position */
extern void sender_last (void);

/*+
  Change smtp sever, via which the message is going to be
  sent.  Changing smtp server affects from field, but changing
  from doesn't affect smtp server.
  +*/
/** change smtp server */
extern void sender_change_smtp (void);
/** change from */
extern void sender_change_from (void);
/** change reply-to */
extern void sender_change_reply_to (void);
/** change to */
extern void sender_change_to (void);
/** change cc */
extern void sender_change_cc (void);
/** change bcc */
extern void sender_change_bcc (void);
/** change subject */
extern void sender_change_subject (void);

/** attach a file */
extern void sender_add_attachment (void);
/** remove attachment */
extern void sender_delete_attachment (void);
/** change content-type of attachment */
extern void sender_change_type (void);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER sender.h
 *
 ****************************************************************************/
#endif
