# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'


from elisa.base_components.model import Model

class WeatherModel(Model):
    """
    Modelize the weather.

    @ivar location: the location, the data where taken at
    @type location: string

    @ivar temp:  temperature in celsius
    @type temp: float

    @ivar wind_speed:  speed of the wind in kilometers per hour (km/h)
    @type wind_speed: integer

    @ivar wind_dir:  direction of the wind in degrees (°)
    @type wind_dir:  integer

    @ivar press:  pressure in hectopasca (hPa)
    @type press: float

    @ivar dew:  the dew point in celsius
    @type dew: float

    @ivar relHumidity:  the relative Humidity in percent
    @type relHumidity: float

    @ivar icon: what icon to use
    @type icon: string
    """
    location = ''
    temp = 0
    relHumidity = 0
    wind_speed = 0
    wind_dir = 0
    press = 0
    dew = 0
    sky = ''
    icon = ''
    view = 0

    def __repr__(self):
        return "<WeatherModel instance %r for has got this data:\n\t Location: %s\n\t Temp: %s\n\t Humidity: %s\n\t Wind speed: %s\n\t Wind direction: %s\n\t Pressure: %s\n\t Dew point: %s\n\t Sky conditions: %s\n\t the Icon: %s\n\t\t\t\t\t\t\t>" % (id(self),self.location,self.temp, self.relHumidity,self.wind_speed,self.wind_dir,self.press,self.dew,self.sky,self.icon)
