-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for Gtk?Paned objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_paned_writer.e,v 1.6 2000/08/31 14:02:17 elphick Exp $"

deferred class GTK_PANED_WRITER

inherit

	GTK_COMPOSED_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end

	CHILD

feature

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		local
			tree_array: ARRAY[TAG_TREE]
		do
			make_attribute(attr_name, tree, src)
			handle_size := widget_tree.get_integer_string_from_field("handle_size")
			gutter_size := widget_tree.get_integer_string_from_field("gutter_size")
			position := widget_tree.get_integer_string_from_field("position")
			tree_array := widget_tree.find_children("widget")
			if tree_array /= Void and then tree_array.count > 2 then
				print("Paned widgets can only have 2 children. ")
				print("Ignoring extra ones%N")
			end
			-- This probably seems obscure. It is.
			-- Basically if the first widget is a placeholder, then using
			-- create_child_class_array will skip it and move up the second one
			-- to take its place, which defeats the object of placeholders.
			!!widgets.make(1,0)
			create_child_class(tree_array @ 0, 1)
			widgets.force(last_class, 0)
			create_child_class(tree_array @ 1, 1)
			widgets.force(last_class, 1)
			-- this way our we don't need to redefine parent_declaration
			-- and parent_inherit. parent_creation which is redefined can tell
			-- which pane it is by the position in the array
		end
			
	handle_size: STRING
	gutter_size: STRING
	position: STRING
	
	append_parent_creation(code: ARRAY[STRING]) is
		local
			temp_child: CHILD
		do
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".set_handle_size(" + handle_size + ")")
			code.add_last(name + ".set_gutter_size(" + gutter_size + ")")
			if position /= Void then
				code.add_last(name + ".set_handle_position(" + position + ")")
			end
			add_widget_code(code)
			if widgets.lower = 0 then
				(widgets @ 0).append_parent_creation(code)
				temp_child ?= widgets @ 0
				code.add_last(name + ".pack1(" + (widgets @ 0).name + ", " +
					temp_child.boolean_property("shrink") + ", " +
					temp_child.boolean_property("resize") + ")")
			end
			if widgets.upper = 1 then
				(widgets @ 1).append_parent_creation(code)
				temp_child ?= widgets @ 1
				code.add_last(name + ".pack2(" + (widgets @ 1).name + ", " +
					temp_child.boolean_property("shrink") + ", " +
					temp_child.boolean_property("resize") + ")")
			end
		end

end
