-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkImage objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_image_writer.e,v 1.7 2000/07/10 11:31:12 elphick Exp $"

class GTK_IMAGE_WRITER

inherit

   GTK_ATTRIBUTE_WRITER
      rename
	 make as make_attribute
      redefine
	 append_parent_declaration, append_parent_creation
      end

	CHILD

creation

	make

feature

		
	type: STRING is "GTK_IMAGE"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			image_width := widget_tree.get_integer_string_from_field("image_width")
			image_height := widget_tree.get_integer_string_from_field("image_height")
			image_type := widget_tree.get_string_from_field("image_type")
			image_visual := widget_tree.get_string_from_field("image_visual")
		end
			
	image_width: STRING
	image_height: STRING
	image_type: STRING
	image_visual: STRING
	
	append_parent_declaration(code: ARRAY[STRING]) is
		do
			code.add_last(name + ": " + type)
			code.add_last(name + "_gdk_image: GDK_IMAGE")
		end

	append_parent_creation(code: ARRAY[STRING]) is
		do
			-- Doesn't create it yet cos i don't know what it's supposed to do
			-- nor how to do it
			-- add_widget_code(code)
		end

end
