-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkFixed objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_fixed_writer.e,v 1.10 2000/08/31 14:02:17 elphick Exp $"

class GTK_FIXED_WRITER

inherit

	GTK_COMPOSED_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, append_add_widget_code
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_FIXED"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			create_child_class_array(widget_tree.find_children("widget"), 1)
		end
			
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!"+ name + ".make")
			add_widget_code(code)
			precursor(code)
		end

	append_add_widget_code(code: ARRAY[STRING]; widget: CAN_BE_CREATED) is
		local
			attr: GTK_ATTRIBUTE_WRITER
		do
			attr ?= widget
			if attr /= Void then
				code.add_last(name + ".attach(" + widget.name + ", " +
					attr.x + ", " + attr.y +")")
			else
				print("Fixed writer can only handle attributes.%N")
				die_with_code(exit_failure_code)
			end
		end

end
