/* Copyright (C) 2001 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef FAX_LIST_H
#define FAX_LIST_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <string>

#include <gtk--/window.h>
#include <gtk--/table.h>
#include <gtk--/button.h>
#include <gtk--/clist.h>
#include <gtk--/scrolledwindow.h>
#include <gtk--/entry.h>
#include <gtk--/label.h>
#include <gtk--/main.h>
#include <gtk--/toolbar.h>
#include <gtk--/box.h>

#include "prog_defs.h"
#include "pipes.h"

// this class is modeless, and does not have a run method
// it is self-owning and will delete itself
class FaxListDialog: public Gtk::Window {
public:
  enum Mode {received, sent};
private:
  Mode mode;
  static int is_fax_received_list;
  static int is_fax_sent_list;
  const int standard_size;
  Gtk::VBox fax_list_box;
  Gtk::Table table;
  Gtk::Toolbar tool_bar;
  Gtk::ScrolledWindow fax_list_scroll_window;
  Gtk::Button close_button;
  Gtk::CList fax_list;
  Gtk::CList_Helpers::SelectionList selection;
  Gtk::Button* print_button_p;
  Gtk::Button* view_button_p;
  Gtk::Button* describe_button_p;
  Gtk::Button* delete_button_p;
  void get_fax_list_rows(void);
  void close_slot(void);
  void set_buttons_slot(gint, gint, GdkEvent*);
  void refresh_slot(void);
  void describe_fax_prompt(void);
  void describe_fax_prompt_witharg(gint) {describe_fax_prompt();}
  void describe_fax(const std::string&);
  void print_fax_prompt(void);
  void print_fax(void);
  void view_fax(void);
  void view_fax_multi_page(const std::string&);
  void view_fax_single_page(const std::string&);
  void delete_fax_prompt(void);
  void delete_fax(void);
protected:
  virtual gint delete_event_impl(GdkEventAny*);
public:
  static int get_is_fax_received_list(void) {return is_fax_received_list;}
  static int get_is_fax_sent_list(void) {return is_fax_sent_list;}

  FaxListDialog(Mode, const int standard_size_);
  ~FaxListDialog(void);
};

class DescriptionDialog: public Gtk::Window {

  bool in_run_loop;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::Label label;
  Gtk::Table table;
  Gtk::Entry entry;
  Gtk::Window& parent;
protected:
  virtual gint delete_event_impl(GdkEventAny*);
  virtual gint key_press_event_impl(GdkEventKey*);
public:
  void selected(bool);
  SigC::Signal1<void, const std::string&> accepted;
  void run(void);
  DescriptionDialog(const int standard_size, const std::string& text, Gtk::Window& window);
};

#endif
