/* (C) 1999-2000 Patrick Lambert <drow@post.com> */
#ifdef USE_GNOME
#include <gnome.h>
#else
#include <gtk/gtk.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef USE_IMLIB
#include <gdk_imlib.h>
#include <gdk/gdk.h>
#endif
#ifdef USE_MAGICK
#include <magick.h>
#endif
#undef USE_GNOME_CONFIG
#define E_VERSION "1.2"
#define E_DEBUG TRUE
#define E_VERTICAL GTK_ORIENTATION_VERTICAL
#define E_HORIZONTAL GTK_ORIENTATION_HORIZONTAL
#define E_DEFAULT_STYLE GTK_BUTTONBOX_DEFAULT_STYLE
#define E_SPREAD GTK_BUTTONBOX_SPREAD
#define E_EDGE GTK_BUTTONBOX_EDGE
#define E_START GTK_BUTTONBOX_START
#define E_END GTK_BUTTONBOX_END
#define E_LEFT GTK_POS_LEFT
#define E_RIGHT GTK_POS_RIGHT
#define E_TOP GTK_POS_TOP
#define E_BOTTOM GTK_POS_BOTTOM
#define E_MSB_LONG_ADDR(a, b, c, d) ((a << 0x18) | (b << 0x10) | (c << 0x08) | (d))
#define E_LSB_LONG_ADDR(d, c, b, a) E_MSB_LONG_ADDR(a, b, c, d)
#define E_EVENT_METHOD(i, x) GTK_WIDGET_CLASS(GTK_OBJECT(i)->klass)->x

typedef struct _E_Wizard E_Wizard;
struct _E_Wizard {
 GtkWidget *window;
 GtkWidget *entry;
};

typedef struct _E_Editor E_Editor;
struct _E_Editor {
 GtkWidget *window;
 GtkWidget *menu;
 GtkWidget *box;
 GtkWidget *text;
 GtkSignalFunc menu_open;
 GtkSignalFunc menu_new;
 GtkSignalFunc menu_save;
 GtkSignalFunc menu_copy;
 GtkSignalFunc menu_cut;
 GtkSignalFunc menu_paste;
 GtkSignalFunc menu_close;
 GtkSignalFunc menu_about;
 gint menu_file;
 gint menu_edit;
 gint menu_help;
 gint editable;
 gint init_load;
 gchar filename[1024];
};

gchar current_list_selection[4096];
gchar internal_result[1024], internal_tree[1024];
gint current_radiobutton, current_list_row;
gint internal_event_x, internal_event_y;
GtkWidget *e_hruler, *e_vruler, *e_table;

#ifdef USE_IMLIB
GdkImlibImage *g_im;
#endif

void E_NO_FUNC();

GtkWidget *e_window_create(char *title, gint size_x, gint size_y, gint position_x, gint position_y, GtkSignalFunc window_destroy);

void e_set_size(GtkWidget *widget, gint size_x, gint size_y);

GtkWidget *e_box_create(GtkWidget *parent, gint placement, gint border);

GtkWidget *e_box_fixed(GtkWidget *parent, gint placement, gint border);

GtkWidget *e_text_create(GtkWidget *parent, gint editable, gchar *initial_text, GtkSignalFunc text_changed);

gint e_text_find(GtkWidget *text, char *search_string);

void e_text_insert(GtkWidget *textarea, gchar *text);

void e_text_insert_file(GtkWidget *textarea, gchar *filename);

gchar *e_text_get(GtkWidget *textarea);

void e_text_delete(GtkWidget *textarea);

GtkWidget *e_label_create(GtkWidget *parent, gchar *text);

GtkWidget *e_entry_create(GtkWidget *parent, gchar *initial_text);

gchar *e_entry_get(GtkWidget *entry);

GtkWidget *e_button_create(GtkWidget *parent, gchar *text, GtkSignalFunc button_click);

GtkWidget *e_combo_create(GtkWidget *parent, gchar *initial_text, gchar *combo_list[], gint num, GtkSignalFunc item_selected);

char *e_combo_get(GtkWidget *combo);

void e_list_setup(GtkWidget *list, gint col, gchar *title, gint width);

gchar *e_list_get();

void e_internal_list_select(GtkWidget *list, gint c, gint r);

void e_list_insert(GtkWidget *list, gchar *text[]);

GtkWidget *e_list_create(GtkWidget *parent, gint cols, GtkSignalFunc item_selected);

void e_list_remove(GtkWidget *list);

GtkWidget *e_buttonbox_create(GtkWidget *parent, gint orientation, gchar *button1_text, gchar *button2_text, GtkSignalFunc button1_click, GtkSignalFunc button2_click);

GtkWidget *e_buttonbox_unlim(GtkWidget *parent, gint orientation, guint num_buttons, ...);

GSList *e_radiobuttons_create(GtkWidget *parent, gchar *items[], gint num);

void e_internal_radiobutton(GtkWidget *widget, gint t);

gint e_radiobuttons_get();

void e_radiobuttons_setdefault(gint choice);

GtkWidget *e_checkbutton_create(GtkWidget *parent, gchar *text, gint default_state, GtkSignalFunc button_checked);

gint e_checkbutton_get(GtkWidget *checkbutton);

GtkWidget *e_notebook_create(GtkWidget *parent, gint placement);

GtkWidget *e_notebook_new_page(GtkWidget *notebook, gchar *title, gchar *description);

GtkWidget *e_show_message(gchar *title, gchar *message, GtkSignalFunc window_destroy);

GtkWidget *e_browse_create(gchar *title, GtkSignalFunc ok_clicked, GtkSignalFunc cancel_clicked);

gchar *e_browse_get(GtkWidget *browse);

GtkWidget *e_font_create(gchar *title, GtkSignalFunc ok_clicked, GtkSignalFunc cancel_clicked);

gchar *e_font_get(GtkWidget *fs);

GtkWidget *e_scrolled_create(GtkWidget *parent);

GtkWidget *e_toolbar_create(GtkWidget *parent, int orientation);

void e_toolbar_insert(GtkWidget *toolbar, gchar *name, gchar *description, GtkWidget *icon, GtkSignalFunc button_clicked);

GtkWidget *e_icon_create(GtkWidget *window, gchar *filename);

#ifdef USE_IMLIB
GtkWidget *e_image_create(GtkWidget *parent, gchar *filename);

GtkWidget *e_image_scaled(GtkWidget *parent, gchar *filename, gint size_x, gint size_y);

GdkWindow *e_image_window(gchar *filename);

GdkImlibImage *e_image_get();

void e_image_flip(GdkImlibImage *im, gint orientation);
#endif

GtkWidget *e_menu_create(GtkWidget *parent);

GtkWidget *e_menu_insert_menu(GtkWidget *menubar, gchar *name, gint justify);

GtkWidget *e_menu_insert_item(GtkWidget *menu, gchar *name, GtkSignalFunc item_clicked);

gchar *e_lrange(gchar *input_string, gint starting_at);

gchar *e_lindex(gchar *input_string, gint word_number);

gchar *e_lindex_delim(gchar *input_string, gint word_number, gchar *delim);

gchar *e_config_fetch(gchar *filename, gchar *key);

gint e_config_update(gchar *filename, gchar *key, gchar *data);

gint e_config_insert(gchar *filename, gchar *key, gchar *data);

GtkWidget *e_tree_create(GtkWidget *parent);

GtkWidget *e_tree_insert_subtree(GtkWidget *tree, gchar *name);

GtkWidget *e_tree_insert_item(GtkWidget *tree, gchar *name, GtkSignalFunc item_clicked);

gchar *e_tree_get();

void e_internal_tree_item(GtkWidget *item);

#ifdef USE_MAGICK
gint e_image_convert(gchar *infile, gchar *outfile);

void e_image_display(gchar *filename);
#endif

GtkWidget *e_pixmap_create(char *xpm_data[], GdkWindow *window);

gushort e_internal_convert_color(unsigned c);

void e_internal_extract_color(GdkColor *color, unsigned red, unsigned green, unsigned blue);

GtkWidget *e_button_create_with_pixmap(GtkWidget *parent, GtkWidget *pixmap, GtkSignalFunc button_clicked);

GtkWidget *e_event_create(GtkWidget *parent, gint size_x, gint size_y, GtkSignalFunc area_clicked);

void e_internal_event_clicked();

gint e_event_get_x();

gint e_event_get_y();

GtkWidget *e_query_create(gchar *title, gchar *message, GtkSignalFunc ok_clicked, GtkSignalFunc cancel_clicked);

gchar *e_query_get(GtkWidget *query);

GtkWidget *e_show_textbox(gchar *title, gchar *initext, GtkSignalFunc close_window);

GtkWidget *e_button_fixed(GtkWidget *parent, gchar *text, GtkSignalFunc button_click);

GtkWidget *e_menu_insert_line(GtkWidget *menu);

E_Wizard *e_wizard_create(gchar *title, GtkWidget *icon, gchar *text, gint entry_box, GtkSignalFunc prev_button, GtkSignalFunc next_button, GtkSignalFunc cancel_button);

void e_box_add(GtkWidget *parent, GtkWidget *widget, gint placement, gint fill);

void e_editor_create(E_Editor *editor);
