.TH DXPC 1 "November 11, 2002" "dxpc"
.ad b
.SH NAME
dxpc - Differential X Protocol Compressor

.SH RELEASE
3.8.2

.SH SYNOPSIS
.BR dxpc
\fB[common] [client | server] [connect]\fR
.br

\fB[common]\fR options are:
.br
	-p \fIport_num\fR -f -k -v -s \fIdebug_level\fR -l \fIlog_file\fR
.br

\fB[client]\fR options (valid for CLIENT process) are:
.br
	-i \fIcompression_lvl\fR -d \fIdisplay_num\fR -u
.br

\fB[server]\fR options (valid for SERVER process) are:
.br
	-D \fIdisplay\fR -b(a|w)
.br

\fB[connect]\fR options are:
.br
	\fIhostname\fR -w
.SH DESCRIPTION
\fBdxpc\fR is an X protocol compressor designed to improve the
speed of X11 applications run over low-bandwidth links (such as dialup
PPP connections).
.sp
dxpc must be run at both ends of a low-bandwidth link.  On the host
where the real X server is, dxpc runs in "Server Proxy" mode.  On the
host at the other end of the link, dxpc runs in "Client Proxy" mode.
The Client Proxy dxpc must be started first.  When the Server Proxy
dxpc is started, it connects to the Client Proxy.  (Note that versions
of dxpc before 3.3.1 used the opposite convention.)  If either of the
two communicating dxpc instances is subsequently terminated, the other
one automatically shuts down.
.sp
The Client Proxy mimics an X server.  X client applications connect
to the Client Proxy using display "unix:8" (or "<hostname>:8"; dxpc
supports both UNIX domain and TCP sockets).  The Client Proxy receives
X requests from the application, compresses them, and sends them to
the Server Proxy.  The Server Proxy uncompresses the requests and
sends them to the real X server.  Similarly, the Server Proxy receives
X events, replies, and errors from the real X server.  It compresses
these messages and sends them to the Client Proxy, which uncompresses
them and sends them to the client application.
.sp
The compression performance of dxpc depends upon the types of X applications
being run.  For many applications, dxpc achieves between 3:1 and 6:1
compression of the X protocol traffic.
.sp
.SH MODES
dxpc has two modes; the connection mode, which is either \fIlistening\fR or
\fIconnecting\fR; and the X mode, which is either \fIclient\fR or \fIserver\fR.
.sp
The \fIlistening\fR process waits for a \fIconnecting\fR process to initiate the TCP
connection between the two processes. The \fIlistening\fR process must always be
started first. The \fIconnecting\fR process initiates the connection to the
\fIlistening\fR process. dxpc will run as the \fIconnecting\fR process if a hostname
argument is supplied (see connect options, above). Otherwise it will run as
the \fIlistening\fR process.
.sp
The \fIserver\fR process is typically located on the same machine as the real X
server, and is responsible for displaying the output of applications. The
\fIclient\fR process is typically located on the same machine as the X
applications, and is responsible for forwarding the output of those
applications to the \fIserver\fR process. By default, dxpc runs as the \fIclient\fR
process if it is the \fIlistening\fR process (due to the lack of a hostname
argument) and the \fIserver\fR process if it is the \fIconnecting\fR process, but the -w
switch reverses this.
.sp
For example, the command \fBdxpc myhost.work.com\fR starts dxpc as the
\fIconnecting\fR process (because a host name is supplied) and the \fIserver\fR process
(because it is the \fIconnecting\fR process and -w is not supplied). The command
\fBdxpc -w\fR starts dxpc as the \fIlistening\fR process (because no hostname is
supplied) and the \fIserver\fR process (because it is the \fIlistening\fR process, and
-w reverses the usual logic).
.sp
.SH Options
.TP 12
.B -b(a|w)
This option specifies that any windows created should be created with
the BackingStore option set to Always (\fB-ba\fR) or WhenMapped
(\fB-bw\fR), if the application has not set the option itself.  Using
the BackingStore option will reduce traffic to repaint exposed regions
of the window, at the cost of extra memory use in the X server itself.
(This option is ignored in Client Proxy mode.)

.B NOTE:
The \fB-ba\fR option can cause Expose events to be sent before the
client has mapped its windows.  This can confuse some client programs,
notably GNU Emacs version 20.3.  The "bug" in this case is that dxpc
shouldn't be setting BackingStore to Always behind the application's
back.  Neverless, the option is available, if you want to try it; many
client programs still function fine with it, and it will cause the
contents of iconified windows to be retained.

.TP 12
.B -d \fIdisplaynum\fR
This option specifies the number of the X display that dxpc imitates.
The default value is 8.  (This option is ignored in Server Proxy mode.)

.TP 12
.B -f
This option tells dxpc to fork and run as a daemon process.  All subsequent
non-error output is suppressed, including statistics reports.  The daemon
can be killed by use of the \fB-k\fR option.

.TP 12
.B -k
This option tells dxpc to read a pid from the lockfile in the user's home
directory and then send a SIGKILL to the old process.  It does some error
checking to try to ensure that the file contains a valid pid file (and
nothing else).  The pidfile will exist only if dxpc was started with the
\fB-f\fR option.

.TP 12
.B -l
This option is used to tell dxpc to write messages and statistics to a
logfile.  Very useful with the \fB-f\fR option.

.TP 12
.B -p \fIportnumber\fR
This option specifies the TCP port number to be used for communication between
the Client Proxy and the Server Proxy.  The default value is 4000.

.TP 12
.B -s(1|2)
Print a report on dxpc's compression performance for an X application when
the application exits.  In Client Proxy mode, dxpc displays a report on the
compression of messages generated by the X client.  In Server Proxy mode,
dxpc displays a report on the compression of messages generated by the X
server.  The \fB-s1\fR option yields a simple report that provides the
overall compression ratio.  The \fB-s2\fR option yields a far more detailed
report on the compression ratios achieved for all the individual message
types in the X protocol.  The \fB-s2\fR option is the "hacker option"; most
people will probably want the \fB-s1\fR report instead.

.TP 12
.B "-u -t"
Normally, dxpc in Client Proxy mode imitates an X display, :8 by default,
by listening on both a UNIX domain socket and a TCP socket.  The \fB-u\fR
option tells it not to use the UNIX domain port, and the \fB-t\fR option
tells it not to use the TCP port.  (These options are ignored in Server
Proxy mode.)

.TP 12
.B "-v"
This option tells dxpc to print out its version number and copyright
message and exit.

.TP 12
.B "-w"
Use of this option swaps the connection sequence.  That is, the client will
initiate the connection to the server.  Thus, instead of starting the
client like \fBdxpc -f\fR and the server as \fBdxpc -f workserver\fR, you
can start the client as \fBdxpc -w -f homepc\fR and the server as \fBdxpc
-w -f\fR.  This option is intended to be useful for people running the
client proxy on a machine behind a firewall.

.TP 12
.B \fIhostname\fR
This argument must be used in Server Proxy mode to tell dxpc the hostname or
IP address of the machine where other dxpc (the one in Client Proxy mode) is
running.  (Note that the presence of this argument is what puts dxpc in Server
Proxy mode.  If this argument is not used, dxpc runs in Client Proxy mode.)

.TP 12
.B "-D display"
Specify X host on which to display proxied applications. Defaults to
value of the DISPLAY environment variable.

.TP 12
.B "-i(0..9|99|999)"
This option controls bitmap image compression. This option is only valid on
the instance which is accepting connections; usually this is the client, but
the -w option will reverse this, making the -i option valid only on the
server. The specified number is the image compression level; higher levels
offer better compression at the cost of greater CPU and memory utilization
(mostly on the client proxy). The actual behavior of each level is given
below.

0 : No compression (except for the very limited compression supported in
dxpc 3.7.0). In other words, behaves like 3.7.0 (but is incompatible with
it)

1 : LZO lzo1x_1 compression; very fast, low CPU and memory use, reasonable
compression.

2-9: LZO lzo1c_... variant compression algorithms. lzo1c_2 actually seems to
be worse than lzo1x_1...  

99: LZO lzo1c_99 algorithm. Slow, but pretty good compression. NB: I have
seen a couple of unexplained crashes when using this level. Not recommended. 

999: LZO lzo1x_999 compression. Slow (but fast enough to feed a 128K ISDN
link when hosted on a Pentium II/300 without maxing out the processor),
but good compression. This is the default and recommended value.


.SH EXAMPLES
Assume that you're running a real X server on the console of a local
workstation called homepc, and that you want to run some X applications on
a remote system called workserver and have them display on the console of
the local system.
.sp
On workserver, run
.nf
	$ export DISPLAY=homepc:0
    $ dxpc -f
    $ export DISPLAY=unix:8
.fi

On homepc, run
.nf
    $ export DISPLAY=unix:0
    $ dxpc -f workserver
.fi

Now on workserver,
.nf
    $ xterm&
    $ xemacs&
    etc...
.fi

.SH "DXPC AND XAUTH"
If you use X authorization, with a .Xauthority file on the workstation
where your real X server runs, you'll need to set up a .Xauthority file
on the host where the ClientProxy runs.  One way to do this is:
.sp
Copy your ~/.Xauthority file from the host where the real X server
runs to the host where the Client Proxy runs.
.sp
Run
.nf
    xauth list
.fi
to see the authorization keys.  There should be one for your
real X display.  It will look something like this:
.nf
    <hostname>/unix:0   MIT-MAGIC-COOKIE-1   <hex string>
.fi
On the host where the Client Proxy is located, add a new entry to
the .Xauthority file with the display name of the fake X server (the
DISPLAY where the Client Proxy is listening) and all of the other
values from the entry for the real X display.  The xauth "add"
command can be used, like this:
.nf
    xauth add <hostname>/unix:8 MIT-MAGIC-COOKIE-1  <hex string>
.fi
where <hostname> is the name of the host where the Client Proxy is running
and <hex string> has the same value as the <hex string> obtained for
the real X display in step 2.  Once you do this, you should be
able to run X clients through dxpc successfully.


.SH TROUBLESHOOTING
.B "Some windows don't appear."
This can happen if the \fB-ba\fR option is used, and a client program
(such as GNU Emacs version 20.3) does not request backing store and
thus assumes that Expose events imply that the window has been mapped.
Use \fB-bw\fR, or leave out the \fB-b\fR option altogether.

.B "No windows appear."
This can happen if you are using a newer version of dxpc with an older
one, from before the client and server roles were changed.  A
connection can be established between them, but both sides believe
themselves to be the client side, or both sides believe themselves to
be the server side.  Make sure you're using the same version of dxpc
at both ends of the connection.

.SH AUTHOR
Brian Pane

.SH MAINTAINER
Kevin Vigor (kevin@vigor.nu)

.SH ACKNOWLEDGMENTS
\fBdxpc\fR has adopted many good ideas from the \fBHBX\fR and \fBFHBX\fR
systems (http://www.cs.dartmouth.edu/~jmd/decs/DECSpage.html).
.sp
Thanks to all of the users of dxpc who have contributed feedback and
suggestions.

.SH SEE ALSO
xauth(1), README file from dxpc distribution
