/*********************************************************************************************************
DVR, Digital Video Recorder - a tool to record movies (audio/video), using realtime compression

It uses libavifile (see http://divx.euro.ru) and some code from kwintv (see wenk@mathematik.uni-kl.de)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General
Public License as published by the Free Software Foundation, etc.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY, etc.

copyright(C) february 2001, Pierre Hbert (pierre.hebert@netcourrier.com)
*********************************************************************************************************/
#include <pthread.h>
#include <sys/time.h>
#include <string>
#include <avifile/avifile.h>

#include "parameter_list.h"


class V4L;
class FramePool;


class DVR {

public:
	// enumerations
	enum DvrStatus { DVR_READY, DVR_RECORDING, DVR_RECORD_DONE, DVR_STOP_ASKED };

	// functions and methods
	DVR();
	~DVR();

	bool initialize();
	bool isGood() const { return good; }
	string errorMessage() const { 	return error_message; }
	bool startRecording();
	bool stopRecording();

	DvrStatus getStatus() const { return status; }

	void setPreview(bool on);

	int			nbFramesElapsed() const { return nb_frames_elapsed; }	
	int			nbFramesStored() const { return nb_frames_stored; }	
	int			nbFramesLostInCapture() { return nb_frames_lost_in_capture; }
	int			nbFramesLostInEncoding() { return nb_frames_lost_in_encoding; }
	int			nbFramesInEncQueue();

	V4L	    *getV4l() { return v4l; }
	struct timeval	startRecordingTime() const { return start_recording_time; }

	int     parameterAsInt(const string &param_name);
	double  parameterAsDouble(const string &param_name);
	string  parameterAsString(const string &param_name);

	void setParameter(const string &param_name, int value);
	void setParameter(const string &param_name, double value);
	void setParameter(const string &param_name, string value);
	void listParameters() { param_list.listParameters(); }
	
  FramePool *externalFramepool() { return external_fp; }

private:
	ParameterList param_list;

	bool	good, initialized;
	string error_message;

	FramePool				*fp;
	IAviWriteFile 	*avi_file;
	V4L 					  *v4l;

	// semaphores identifiers
	int			sem_avi_file;					// mutex on avi_file
	int			sem_are_you_ready;		// synchro threads start

	// threads identifiers
	pthread_t	t_video_capture_storage,
						t_video_encoding,
						t_audio_encoding;

	// monitoring		
	struct timeval		start_recording_time;
	int			nb_frames_elapsed;
	int			nb_frames_stored;
	int			nb_frames_lost_in_capture;
	int			nb_frames_lost_in_encoding;
	
	DvrStatus status;

	// parameters for recording
	int			max_recording_time;
	
	int 		video_width;
	int 		video_height;
	int 		video_pixel_format;
	int 		video_top_margin;
	int 		video_bottom_margin;
	string	video_codec_name;
	double  capture_frame_rate;
	double  video_frame_rate;
	string	video_device;
	int			video_channel;
	int			video_norm;
	
	int			sound_recording_enabled;
	int			sound_sample_size;
	int			sound_frequency;
	int			sound_channels;
	int			sound_format;						// compression format, not capture (only PCM for the moment)
	int			sound_byterate; 				// byterate not bitrate
	string	sound_device;
	
	
	int			file_segment_size;			// in MBytes
	string	file_name;

  int    allow_external_frame_reading;    // allow another reader to retrieve captured frames
	FramePool				*external_fp;
  

	
	static double now();	
	//void inc_date(struct timeval &, double);
	
	// functions and methods of the recording core
	bool endRecording();
	static void *video_capture_storage(void *);
	static void *video_encoding(void *);
	static void *audio_encoding(void *);
	static void wait_for_all_threads_ready(void *);
};
