#ifndef __SAA7146_CORE__
#define __SAA7146_CORE__

#include <asm/io.h>		/* definitions of u32 etc. */
#include <linux/i2c.h>

#if LINUX_VERSION_CODE < 0x020300
#define DECLARE_MUTEX(foo)         struct semaphore foo = MUTEX
#define DECLARE_MUTEX_LOCKED(foo)  struct semaphore foo = MUTEX_LOCKED
#define WAIT_QUEUE                 struct wait_queue*
#define init_waitqueue_head(wq)    *(wq) = NULL;
#else
#define WAIT_QUEUE                 wait_queue_head_t
#endif

/* maximum number of capture frames we support */
#define SAA7146_MAX_BUF		5
/* maximum number of saa7146s we support */
#define SAA7146_MAX_DEVICES	4
/* maximum number of extensions we support */
#define SAA7146_MAX_EXTENSIONS	4

/* stuff for writing to saa7146 */
#if defined(__powerpc__) /* big-endian */
extern __inline__ void io_st_le32(volatile unsigned *addr, unsigned val)
{
        __asm__ __volatile__ ("stwbrx %1,0,%2" : \
                            "=m" (*addr) : "r" (val), "r" (addr));
      __asm__ __volatile__ ("eieio" : : : "memory");
}

#define saa7146_write(mem,adr,dat)    io_st_le32((unsigned *)(mem+(adr)),(dat))
#define saa7146_read(mem,adr)         ld_le32((unsigned *)(mem+(adr)))
#else
#define saa7146_write(mem,adr,dat)    writel((dat),(mem+(adr)))
#define saa7146_read(mem,adr)         readl(mem+(adr))
#endif


/* this struct contains some constants needed for horizontal and vertical scaling. 
   currently we only support PAL (mode=0)and NTSC (mode=1). */

struct saa7146 {

        char			name[32];	/* give it a nice name */

	struct i2c_adapter	*i2c_adap;	
	struct pci_dev		*device;

	void*			  data[SAA7146_MAX_EXTENSIONS];	/* data hooks for extensions */

	int (*command)(struct i2c_adapter *i, unsigned int cmd, void *arg);

	unsigned char*		mem;		/* pointer to mapped IO memory */
	int			revision;	/* chip revision; needed for bug-workarounds*/

	int			interlace;
	int			mode;
	
	u32*	i2c;				/* i2c memory */
	u32*	grabbing;			/* grabbing memory */
	u32*	clipping;			/* clipping memory for mask or rectangle clipping*/
	u32*	rps0;				/* memory for rps0-program */
	u32*	rps1;				/* memory for rps1-program */
	u32*	debi;				/* memory for debi-transfers */
	
	int	buffers;			/* number of grabbing-buffers */
		
	u32*	page_table[SAA7146_MAX_BUF];	/* page_tables for buffers*/
	int	frame_stat[SAA7146_MAX_BUF];	/* status of grabbing buffers */

	int grab_width[SAA7146_MAX_BUF];	/* pixel width of grabs */
	int grab_height[SAA7146_MAX_BUF];	/* pixel height of grabs */
	int grab_format[SAA7146_MAX_BUF];	/* video format of grabs */
	int grab_port[SAA7146_MAX_BUF];		/* video port for grab */

        WAIT_QUEUE rps0_wq;                /* rps0 interrupt queue (=> capture) */
        WAIT_QUEUE rps1_wq;                /* rps1 interrupt queue (=> i2c, ...) */

	/* --- administration stuff. */
	int (*client_register)(struct i2c_client *);
	int (*client_unregister)(struct i2c_client *);
};

#define	SAA7146_IRQ_RPS0  
#define	SAA7146_IRQ_RPS1 

struct saa7146_extension {
	char	name[32];
	u32 	handles_irqs;

	void (*irq_handler)(struct saa7146*, u32, void*);

	int (*command)(struct saa7146*, void*, unsigned int cmd, void *arg);

	int (*attach)(struct saa7146*, void**);
	int (*detach)(struct saa7146*, void**);

	void (*inc_use)(struct saa7146*);
	void (*dec_use)(struct saa7146*);
};

int	saa7146_add_extension(struct saa7146_extension* ext);
int	saa7146_del_extension(struct saa7146_extension* ext);

struct saa7146* saa7146_get_handle(int i);

/* external grabbing states */
#define GBUFFER_UNUSED         0x000
#define GBUFFER_GRABBING       0x001
#define GBUFFER_DONE           0x002

#define SAA7146_CORE_BASE	200

#define	SAA7146_DO_MMAP		_IOW('d', (SAA7146_CORE_BASE+11), struct saa7146_mmap_struct)
#define SAA7146_SET_DD1		_IOW('d', (SAA7146_CORE_BASE+12), u32)
#define SAA7146_DUMP_REGISTERS	_IOW('d', (SAA7146_CORE_BASE+13), u32)
#define SAA7146_DEBI_TRANSFER	_IOW('d', (SAA7146_CORE_BASE+14), struct saa7146_debi_transfer)


#define SAA7146_SUSPEND	_IOW('d', (SAA7146_CORE_BASE+32), u32)
#define SAA7146_RESUME	_IOW('d', (SAA7146_CORE_BASE+33), u32)

#endif
