# linda_test.rb - linda unit test
#
# $Date: 2000/07/26 17:58:17 $
# Copyright (c) 2000 Masatoshi SEKI
#
# linda_test.rb is copyrighted free software by Masatoshi SEKI.
# You can redistribute it and/or modify it under the same term as Ruby.

require 'runit/testcase'
require 'runit/cui/testrunner'
require 'tuplespace'

class LindaTest < RUNIT::TestCase
  def test_01_tmpl
    tmpl = TupleSpace::Template.new([1, 2, String])
    assert(tmpl.match([1,2,'Hello']))
    assert(tmpl.match([1,2,'D']))

    tmpl = TupleSpace::Template.new([1, Integer, /^R.*y$/])
    assert(tmpl.match([1,2,'Ruby']))
    assert(tmpl.match([1,0x100000000, 'Ready']))
    assert(! tmpl.match([1, 0.5, 'Lucky']))

    pat = [1, Integer, /^R.*y$/]
    pat2 = Marshal.load(Marshal.dump(pat))
    assert_equal(pat, pat2)
  end

  def test_02_all
    ts = TupleSpace.new
    
    tuple = ['req', 'hello', 'world', 2000]
    ts.out(tuple)
    assert_equal(ts.in(['req', nil, nil, nil]), tuple)

    ts.out(tuple)
    assert_equal(ts.in(['req', String, nil, nil]), tuple)

    ts.out(tuple)
    assert_equal(ts.in(['req', String, nil, Integer]), tuple)
  end

  def test_03_mv
    ts = TupleSpace.new
    ts2 = TupleSpace.new
    
    tuple = ['req', 'hello', 'world', 2000]
    ts.out(tuple)
    ts.mv(ts2, ['req', nil, nil, nil])
    assert_equal(ts2.in(['req', nil, nil, nil]), tuple)
  end
end


if __FILE__ == $0
  RUNIT::CUI::TestRunner.run(LindaTest.suite)
end

  
